/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.UUID;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.service.AbstractUserDetailsService;
import top.dcenter.ums.security.core.api.session.SessionEnhanceCheckService;
import top.dcenter.ums.security.core.auth.mobile.SmsCodeLoginAuthenticationFilter;
import top.dcenter.ums.security.core.auth.mobile.SmsCodeLoginAuthenticationProvider;
import top.dcenter.ums.security.core.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.properties.SmsCodeLoginAuthenticationProperties;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;

@Configuration
@ConditionalOnProperty(prefix="ums.mobile.login", name={"sms-code-login-is-open"}, havingValue="true")
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
public class SmsCodeLoginAutoAuthenticationConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final ValidateCodeProperties validateCodeProperties;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler;
    @Autowired
    private AbstractUserDetailsService userDetailsService;
    @Autowired(required=false)
    private SessionRegistry sessionRegistry;
    @Autowired(required=false)
    private SessionEnhanceCheckService sessionEnhanceCheckService;
    private String key;
    @Autowired(required=false)
    private PersistentTokenRepository persistentTokenRepository;
    @Autowired
    private ClientProperties clientProperties;
    private final SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties;
    private final ObjectMapper objectMapper;

    public SmsCodeLoginAutoAuthenticationConfigurer(ValidateCodeProperties validateCodeProperties, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler, SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties, ObjectMapper objectMapper) {
        this.validateCodeProperties = validateCodeProperties;
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.baseAuthenticationSuccessHandler = baseAuthenticationSuccessHandler;
        this.smsCodeLoginAuthenticationProperties = smsCodeLoginAuthenticationProperties;
        this.objectMapper = objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void configure(HttpSecurity http) {
        SmsCodeLoginAuthenticationFilter smsCodeLoginAuthenticationFilter = new SmsCodeLoginAuthenticationFilter(this.validateCodeProperties, this.smsCodeLoginAuthenticationProperties, this.objectMapper);
        smsCodeLoginAuthenticationFilter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        smsCodeLoginAuthenticationFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.baseAuthenticationSuccessHandler);
        smsCodeLoginAuthenticationFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)this.baseAuthenticationFailureHandler);
        if (this.persistentTokenRepository != null) {
            PersistentTokenBasedRememberMeServices persistentTokenBasedRememberMeServices = new PersistentTokenBasedRememberMeServices(this.getKey(), (UserDetailsService)this.userDetailsService, this.persistentTokenRepository);
            persistentTokenBasedRememberMeServices.setTokenValiditySeconds(Integer.parseInt(String.valueOf(this.clientProperties.getRememberMe().getRememberMeTimeout().getSeconds())));
            persistentTokenBasedRememberMeServices.setParameter(this.clientProperties.getRememberMe().getRememberMeCookieName());
            smsCodeLoginAuthenticationFilter.setRememberMeServices((RememberMeServices)persistentTokenBasedRememberMeServices);
        }
        SmsCodeLoginAuthenticationProvider smsCodeLoginAuthenticationProvider = new SmsCodeLoginAuthenticationProvider(this.userDetailsService);
        http.authenticationProvider((AuthenticationProvider)smsCodeLoginAuthenticationProvider).addFilterAfter((Filter)smsCodeLoginAuthenticationFilter, AbstractPreAuthenticatedProcessingFilter.class);
    }

    private String getKey() {
        if (this.key == null) {
            this.key = UUID.randomUUID().toString();
        }
        return this.key;
    }

    public void key(String key) {
        this.key = key;
    }
}

