/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import top.dcenter.ums.security.core.api.config.HttpSecurityAware;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeFilter;
import top.dcenter.ums.security.core.config.ValidateCodeBeanAutoConfiguration;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;

@Configuration
@AutoConfigureAfter(value={ValidateCodeBeanAutoConfiguration.class})
public class ValidateCodeAutoConfigurerAware
implements HttpSecurityAware {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeAutoConfigurerAware.class);
    private final ValidateCodeProperties validateCodeProperties;
    private final ValidateCodeFilter validateCodeFilter;

    public ValidateCodeAutoConfigurerAware(ValidateCodeProperties validateCodeProperties, ValidateCodeFilter validateCodeFilter) {
        this.validateCodeProperties = validateCodeProperties;
        this.validateCodeFilter = validateCodeFilter;
    }

    @Override
    public void postConfigure(HttpSecurity http) {
        http.addFilterBefore((Filter)this.validateCodeFilter, AbstractPreAuthenticatedProcessingFilter.class);
    }

    @Override
    public void preConfigure(HttpSecurity http) {
    }

    @Override
    public Map<String, Map<String, Set<String>>> getAuthorizeRequestMap() {
        HashMap<Object, Object> permitAllMap = new HashMap<Object, Object>(16);
        ValidateCodeProperties.SliderCodeProperties slider = this.validateCodeProperties.getSlider();
        permitAllMap.put(this.validateCodeProperties.getGetValidateCodeUrlPrefix() + "/*", null);
        permitAllMap.put(slider.getSliderCheckUrl(), null);
        this.validateCodeProperties.getSms().getAuthUrls().forEach(uri -> permitAllMap.put(uri, null));
        this.validateCodeProperties.getImage().getAuthUrls().forEach(uri -> permitAllMap.put(uri, null));
        slider.getAuthUrls().forEach(uri -> permitAllMap.put(uri, null));
        this.validateCodeProperties.getSelection().getAuthUrls().forEach(uri -> permitAllMap.put(uri, null));
        this.validateCodeProperties.getTrack().getAuthUrls().forEach(uri -> permitAllMap.put(uri, null));
        this.validateCodeProperties.getCustomize().getAuthUrls().forEach(uri -> permitAllMap.put(uri, null));
        HashMap<String, Map<String, Set<String>>> resultMap = new HashMap<String, Map<String, Set<String>>>(1);
        resultMap.put("permitAll", permitAllMap);
        return resultMap;
    }
}

