/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.AntPathMatcher;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.enums.LoginProcessType;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.vo.ResponseResult;

public class AuthenticationUtil {
    public static final String EXTRACT_USER_AGENT_REGEX = "[\\.\\d\\s\\(\\)]";

    public static AbstractResponseJsonAuthenticationException getAbstractResponseJsonAuthenticationException(AuthenticationException exception) {
        AbstractResponseJsonAuthenticationException e = null;
        if (exception instanceof AbstractResponseJsonAuthenticationException) {
            e = (AbstractResponseJsonAuthenticationException)exception;
        }
        return e;
    }

    public static boolean isPermitUri(String requestUri, HttpSession session, AntPathMatcher matcher) {
        Map authorizeRequestMap = (Map)session.getServletContext().getAttribute("SERVLET_CONTEXT_AUTHORIZE_REQUESTS_MAP_KEY");
        authorizeRequestMap = Objects.requireNonNullElse(authorizeRequestMap, new HashMap(0));
        Set permitSet = Objects.requireNonNullElse((Set)authorizeRequestMap.get("permitAll"), new HashSet(0));
        for (String permitUri : permitSet) {
            if (!matcher.match(permitUri, requestUri)) continue;
            return true;
        }
        return false;
    }

    public static boolean authenticationFailureProcessing(HttpServletResponse response, AuthenticationException exception, AbstractResponseJsonAuthenticationException e, String acceptHeader, ObjectMapper objectMapper, ClientProperties clientProperties) throws IOException {
        boolean isAcceptHeader;
        boolean isJsonProcessType = LoginProcessType.JSON.equals((Object)clientProperties.getLoginProcessType());
        boolean bl = isAcceptHeader = StringUtils.isNotBlank((CharSequence)acceptHeader) && (acceptHeader.contains("application/x-www-form-urlencoded") || acceptHeader.contains("application/json"));
        if (isJsonProcessType || isAcceptHeader) {
            int status = HttpStatus.UNAUTHORIZED.value();
            ResponseResult result = e != null ? ResponseResult.fail(e.getErrorCodeEnum(), e.getData()) : ResponseResult.fail(exception.getMessage(), ErrorCodeEnum.UNAUTHORIZED);
            AuthenticationUtil.responseWithJson(response, status, objectMapper.writeValueAsString((Object)result));
            return true;
        }
        return false;
    }

    public static void responseWithJson(HttpServletResponse response, int status, String result) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
    }

    public static String extractUserAgent(String userAgent) {
        return userAgent.replaceAll(EXTRACT_USER_AGENT_REGEX, "");
    }

    public static void redirectProcessingLogoutByLoginProcessType(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, ObjectMapper objectMapper, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum) throws IOException {
        AuthenticationUtil.redirectProcessing(request, response, clientProperties, objectMapper, redirectStrategy, errorCodeEnum, clientProperties.getLogoutSuccessUrl());
    }

    public static void redirectProcessingByLoginProcessType(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, ObjectMapper objectMapper, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum, String redirectUrl) throws IOException {
        String referer = Objects.requireNonNullElse(request.getHeader("Referer"), redirectUrl);
        AuthenticationUtil.redirectProcessing(request, response, clientProperties, objectMapper, redirectStrategy, errorCodeEnum, referer);
    }

    public static String getOriginalUrl(RequestCache requestCache, HttpServletRequest request, HttpServletResponse response, String defaultRedirectUrl) throws IOException {
        HttpSession session;
        String originalUrl;
        SavedRequest savedRequest = requestCache.getRequest(request, response);
        String redirectUrl = defaultRedirectUrl;
        if (savedRequest != null) {
            redirectUrl = Objects.requireNonNullElse(savedRequest.getRedirectUrl(), redirectUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)(originalUrl = (String)(session = request.getSession()).getAttribute("SESSION_REDIRECT_URL_KEY")))) {
            redirectUrl = originalUrl;
            session.removeAttribute("SESSION_REDIRECT_URL_KEY");
        }
        return redirectUrl;
    }

    private static void redirectProcessing(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, ObjectMapper objectMapper, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum, String redirectUrl) throws IOException {
        if (LoginProcessType.JSON.equals((Object)clientProperties.getLoginProcessType())) {
            int status = HttpStatus.UNAUTHORIZED.value();
            response.setStatus(status);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(objectMapper.writeValueAsString((Object)ResponseResult.fail(errorCodeEnum, redirectUrl)));
            return;
        }
        redirectStrategy.sendRedirect(request, response, redirectUrl);
    }
}

