/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.logout;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.util.AuthenticationUtil;

public class DefaultLogoutSuccessHandler
implements LogoutSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogoutSuccessHandler.class);
    protected final RedirectStrategy redirectStrategy;
    protected final ClientProperties clientProperties;
    protected final ObjectMapper objectMapper;
    @Autowired(required=false)
    protected UserCache userCache;

    public DefaultLogoutSuccessHandler(ClientProperties clientProperties, ObjectMapper objectMapper) {
        this.clientProperties = clientProperties;
        this.objectMapper = objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.redirectStrategy = new DefaultRedirectStrategy();
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        HttpSession session = request.getSession(true);
        log.info("\u767b\u51fa\u6210\u529f: user={}, ip={}, ua={}, sid={}, sck={}", new Object[]{authentication != null ? authentication.getPrincipal() : "", request.getRemoteAddr(), request.getHeader("User-Agent"), session.getId(), session.getAttribute("SESSION_ENHANCE_CHECK_KEY")});
        session.removeAttribute("SESSION_ENHANCE_CHECK_KEY");
        if (this.userCache != null && authentication != null) {
            this.userCache.removeUserFromCache(authentication.getName());
        }
        AuthenticationUtil.redirectProcessingLogoutByLoginProcessType(request, response, this.clientProperties, this.objectMapper, this.redirectStrategy, ErrorCodeEnum.LOGOUT_SUCCESS);
    }
}

