/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.controller;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.IllegalAccessUrlException;
import top.dcenter.ums.security.core.properties.ClientProperties;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

@ResponseBody
public class InvalidSessionController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(InvalidSessionController.class);
    private final RedirectStrategy redirectStrategy;
    private final ClientProperties clientProperties;
    private final ObjectMapper objectMapper;
    private final RequestCache requestCache;
    @Autowired
    private GenericApplicationContext applicationContext;

    public InvalidSessionController(ClientProperties clientProperties, ObjectMapper objectMapper) {
        this.clientProperties = clientProperties;
        this.requestCache = new HttpSessionRequestCache();
        this.objectMapper = objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.redirectStrategy = new DefaultRedirectStrategy();
    }

    @RequestMapping(value={"${ums.client.invalidSessionUrl}"})
    @ResponseStatus(code=HttpStatus.UNAUTHORIZED)
    public void invalidSessionHandler(HttpServletRequest request, HttpServletResponse response) {
        try {
            String redirectUrl = AuthenticationUtil.getOriginalUrl(this.requestCache, request, response, this.clientProperties.getLoginPage());
            AuthenticationUtil.redirectProcessingByLoginProcessType(request, response, this.clientProperties, this.objectMapper, this.redirectStrategy, ErrorCodeEnum.INVALID_SESSION, redirectUrl);
        }
        catch (Exception e) {
            String requestUri = request.getRequestURI();
            String ip = request.getRemoteAddr();
            String msg = String.format("IllegalAccessUrlException: ip=%s, uri=%s, sid=%s, error=%s", ip, requestUri, request.getSession(true).getId(), e.getMessage());
            log.error(msg, (Throwable)e);
            throw new IllegalAccessUrlException(ErrorCodeEnum.SERVER_ERROR, requestUri, ip);
        }
    }

    public void afterPropertiesSet() throws Exception {
        String methodName = "invalidSessionHandler";
        MvcUtil.setRequestMappingUri(methodName, this.clientProperties.getSession().getInvalidSessionUrl(), this.getClass(), HttpServletRequest.class, HttpServletResponse.class);
        MvcUtil.registerController("invalidSessionController", this.applicationContext, InvalidSessionController.class);
    }
}

