/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes;

import java.io.Serializable;
import java.time.LocalDateTime;

public class ValidateCode
implements Serializable {
    private static final long serialVersionUID = 8564646192066649173L;
    private String code;
    private LocalDateTime expireTime;
    private Boolean reuse;

    public ValidateCode(String code, int expireIn) {
        this.code = code;
        this.expireTime = LocalDateTime.now().plusSeconds(expireIn);
        this.reuse = false;
    }

    public void setExpireTime(int expireIn) {
        this.expireTime = LocalDateTime.now().plusSeconds(expireIn);
    }

    public ValidateCode(String code, int expireIn, Boolean reuse) {
        this.code = code;
        this.expireTime = LocalDateTime.now().plusSeconds(expireIn);
        this.reuse = reuse;
    }

    public boolean isExpired() {
        return LocalDateTime.now().isAfter(this.expireTime);
    }

    public String getCode() {
        return this.code;
    }

    public LocalDateTime getExpireTime() {
        return this.expireTime;
    }

    public Boolean getReuse() {
        return this.reuse;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setReuse(Boolean reuse) {
        this.reuse = reuse;
    }

    public String toString() {
        return "ValidateCode(code=" + this.getCode() + ", expireTime=" + this.getExpireTime() + ", reuse=" + this.getReuse() + ")";
    }
}

