/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.config;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import top.dcenter.ums.security.core.bean.UriHttpMethodTuple;

public interface HttpSecurityAware {
    public static final String PERMIT_ALL = "permitAll";
    public static final String DENY_ALL = "denyAll";
    public static final String ANONYMOUS = "anonymous";
    public static final String AUTHENTICATED = "authenticated";
    public static final String FULLY_AUTHENTICATED = "fullyAuthenticated";
    public static final String REMEMBER_ME = "rememberMe";
    public static final String ACCESS = "access";
    public static final String HAS_ROLE = "hasRole";
    public static final String HAS_ANY_ROLE = "hasAnyRole";
    public static final String HAS_AUTHORITY = "hasAuthority";
    public static final String HAS_ANY_AUTHORITY = "hasAnyAuthority";
    public static final String HAS_IP_ADDRESS = "hasIpAddress";

    public void preConfigure(HttpSecurity var1) throws Exception;

    public void postConfigure(HttpSecurity var1) throws Exception;

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap();

    default public void permitUrlsFillingPermitAllMap(@NonNull Set<String> permitUrls, @NonNull Map<UriHttpMethodTuple, Set<String>> permitAllMap) {
        permitUrls.forEach(uri -> this.permitUrlFillingPermitAllMap((String)uri, permitAllMap));
    }

    default public void permitUrlFillingPermitAllMap(@NonNull String permitUrl, @NonNull Map<UriHttpMethodTuple, Set<String>> permitAllMap) {
        UriHttpMethodTuple tuple = null;
        String[] split = StringUtils.splitByWholeSeparator((String)permitUrl, (String)":");
        switch (split.length) {
            case 1: {
                tuple = UriHttpMethodTuple.tuple(null, split[0]);
                break;
            }
            case 2: {
                HttpMethod method = HttpMethod.resolve((String)split[1]);
                if (method != null) {
                    tuple = UriHttpMethodTuple.tuple(method, split[0]);
                    break;
                }
                tuple = UriHttpMethodTuple.tuple(null, split[0]);
                break;
            }
        }
        if (tuple != null) {
            permitAllMap.put(tuple, null);
        }
    }
}

