/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.image;

import java.awt.image.BufferedImage;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.ServletRequestUtils;
import top.dcenter.ums.security.core.api.validate.code.image.ImageCodeFactory;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageCode;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.util.ImageUtil;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

public class DefaultImageCodeFactory
implements ImageCodeFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultImageCodeFactory.class);
    private final ValidateCodeProperties validateCodeProperties;

    public DefaultImageCodeFactory(ValidateCodeProperties validateCodeProperties) {
        this.validateCodeProperties = validateCodeProperties;
    }

    @Override
    public ImageCode getImageCode(ServletRequest request) {
        ValidateCodeProperties.ImageCodeProperties imageProp = this.validateCodeProperties.getImage();
        int width = imageProp.getWidth();
        int height = imageProp.getHeight();
        int w = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)imageProp.getRequestParaWidthName(), (int)width);
        int h = ServletRequestUtils.getIntParameter((ServletRequest)request, (String)imageProp.getRequestParaHeightName(), (int)height);
        w = Math.min(width * 2, w);
        h = Math.min(height * 2, h);
        int expireIn = imageProp.getExpire();
        int codeLength = imageProp.getLength();
        String code = ValidateCodeUtil.generateVerifyCode(codeLength);
        BufferedImage bufferedImage = ImageUtil.getBufferedImage(w, h, code);
        return new ImageCode(bufferedImage, code, expireIn);
    }
}

