/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.slider;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import top.dcenter.ums.security.core.api.validate.code.slider.SliderCodeFactory;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCode;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCodeUtil;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

public class SimpleSliderCodeFactory
implements SliderCodeFactory {
    private static final Logger log = LoggerFactory.getLogger(SimpleSliderCodeFactory.class);
    private final ValidateCodeProperties validateCodeProperties;

    public SimpleSliderCodeFactory(ValidateCodeProperties validateCodeProperties) {
        this.validateCodeProperties = validateCodeProperties;
    }

    @Override
    public SliderCode getSliderCode() {
        ValidateCodeProperties.SliderCodeProperties slider = this.validateCodeProperties.getSlider();
        try {
            SliderCode sliderCode = SliderCodeUtil.getSliderCodeImage(this.getRandomAbsPath(slider.getOriginalImageDirectory()), slider.getCutWidth(), slider.getCutHeight(), slider.getCircleR(), slider.getRectanglePadding(), slider.getSliderImgOutPadding(), slider.getExpire());
            sliderCode.setToken(ValidateCodeUtil.getUUID());
            return sliderCode;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, null, null);
        }
    }

    private String getRandomAbsPath(String originalImageDirectory) {
        try {
            String[] fileNames;
            File dirFile = ResourceUtils.getFile((String)("classpath:" + originalImageDirectory));
            if (dirFile.isDirectory() && (fileNames = dirFile.list()) != null) {
                int r = ThreadLocalRandom.current().nextInt(fileNames.length);
                return String.format("%s%s%s", dirFile.getPath(), "/", fileNames[r]);
            }
        }
        catch (FileNotFoundException e) {
            log.info(String.format("\u4ea7\u751f slider \u9a8c\u8bc1\u7801\u56fe\u7247\u65f6\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u76f8\u5bf9\u8def\u5f84: %s", originalImageDirectory), (Throwable)e);
        }
        log.info("\u4ea7\u751f slider \u9a8c\u8bc1\u7801\u56fe\u7247\u65f6\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u76f8\u5bf9\u8def\u5f84: {}", (Object)originalImageDirectory);
        throw new RuntimeException("\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u76f8\u5bf9\u8def\u5f84: " + originalImageDirectory);
    }
}

