/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import top.dcenter.ums.security.core.api.config.HttpSecurityAware;
import top.dcenter.ums.security.core.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.properties.ClientProperties;

@Configuration
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class})
public class ClientAutoConfigurerAware
implements HttpSecurityAware {
    public static final String FAVICON = "/**/favicon.ico";
    public static final String JS = "/**/*.js";
    public static final String CSS = "/**/*.css";
    public static final String HTML = "/**/*.html";
    private final ClientProperties clientProperties;

    public ClientAutoConfigurerAware(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Override
    public void postConfigure(HttpSecurity http) {
    }

    @Override
    public void preConfigure(HttpSecurity http) {
    }

    @Override
    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        HashMap<UriHttpMethodTuple, Set<String>> permitAllMap = new HashMap<UriHttpMethodTuple, Set<String>>(16);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, FAVICON), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, JS), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, CSS), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, HTML), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, this.clientProperties.getFailureUrl()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, this.clientProperties.getLoginPage()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, this.clientProperties.getLoginUnAuthenticationRoutingUrl()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.POST, this.clientProperties.getLoginProcessingUrl()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, this.clientProperties.getSuccessUrl()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, this.clientProperties.getErrorUrl()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, this.clientProperties.getError4Url()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple(HttpMethod.GET, this.clientProperties.getError5Url()), null);
        Set<String> permitUrls = this.clientProperties.getPermitUrls();
        this.permitUrlsFillingPermitAllMap(permitUrls, permitAllMap);
        HashMap<String, Map<UriHttpMethodTuple, Set<String>>> resultMap = new HashMap<String, Map<UriHttpMethodTuple, Set<String>>>(1);
        resultMap.put("permitAll", permitAllMap);
        return resultMap;
    }
}

