/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.rememberme.JdbcTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import top.dcenter.ums.security.core.api.config.HttpSecurityAware;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.config.SecurityRememberMeAutoConfiguration;
import top.dcenter.ums.security.core.properties.ClientProperties;

@Configuration
@AutoConfigureAfter(value={SecurityRememberMeAutoConfiguration.class, PropertiesAutoConfiguration.class})
public class RememberMeAutoConfigurerAware
implements HttpSecurityAware,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RememberMeAutoConfigurerAware.class);
    private final ClientProperties clientProperties;
    private final PersistentTokenRepository persistentTokenRepository;
    private final UmsUserDetailsService umsUserDetailsService;

    public RememberMeAutoConfigurerAware(ClientProperties clientProperties, UmsUserDetailsService umsUserDetailsService, PersistentTokenRepository persistentTokenRepository) {
        this.clientProperties = clientProperties;
        this.persistentTokenRepository = persistentTokenRepository;
        this.umsUserDetailsService = umsUserDetailsService;
    }

    @Override
    public void postConfigure(HttpSecurity http) {
    }

    @Override
    public void preConfigure(HttpSecurity http) throws Exception {
        http.rememberMe().rememberMeParameter(this.clientProperties.getRememberMe().getRememberMeParameter()).rememberMeCookieName(this.clientProperties.getRememberMe().getRememberMeCookieName()).tokenRepository(this.persistentTokenRepository).tokenValiditySeconds(Integer.parseInt(String.valueOf(this.clientProperties.getRememberMe().getRememberMeTimeout().getSeconds()))).userDetailsService((UserDetailsService)this.umsUserDetailsService).useSecureCookie(this.clientProperties.getRememberMe().getUseSecureCookie().booleanValue());
    }

    @Override
    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        block25: {
            if (this.persistentTokenRepository != null) {
                JdbcTokenRepositoryImpl jdbcTokenRepository = (JdbcTokenRepositoryImpl)this.persistentTokenRepository;
                DataSource dataSource = jdbcTokenRepository.getDataSource();
                if (dataSource == null) {
                    log.error("\u9519\u8bef: \u4e0d\u80fd\u83b7\u53d6 dataSource \u9519\u8bef");
                    throw new Exception("\u4e0d\u80fd\u83b7\u53d6 dataSource \u9519\u8bef");
                }
                try (Connection connection = dataSource.getConnection();){
                    String database;
                    if (connection == null) {
                        log.error("\u9519\u8bef: \u521d\u59cb\u5316 Remember-me \u7684 persistent_logins \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef");
                        throw new Exception("\u521d\u59cb\u5316 Remember-me \u7684 persistent_logins \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef");
                    }
                    try (ResultSet resultSet = connection.prepareStatement("select database();").executeQuery();){
                        resultSet.next();
                        database = resultSet.getString(1);
                    }
                    if (StringUtils.isNotBlank((CharSequence)database)) {
                        resultSet = connection.createStatement().executeQuery(this.clientProperties.getQueryRememberMeTableExistSql(database));
                        try {
                            resultSet.next();
                            int tableCount = resultSet.getInt(1);
                            if (tableCount < 1) {
                                connection.prepareStatement("create table persistent_logins (username varchar(64) not null, series varchar(64) primary key, token varchar(64) not null, last_used timestamp not null)").executeUpdate();
                                log.info("persistent_logins \u8868\u521b\u5efa\u6210\u529f\uff0cSQL\uff1a{}", (Object)"create table persistent_logins (username varchar(64) not null, series varchar(64) primary key, token varchar(64) not null, last_used timestamp not null)");
                                if (!connection.getAutoCommit()) {
                                    connection.commit();
                                }
                            }
                            break block25;
                        }
                        finally {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                        }
                    }
                    log.error("\u9519\u8bef: \u521d\u59cb\u5316 Remember-me \u7684 persistent_logins \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef");
                    throw new Exception("\u521d\u59cb\u5316 Remember-me \u7684 persistent_logins \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef");
                }
            }
        }
    }
}

