/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.web.context.WebApplicationContext;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.config.HttpSecurityAware;
import top.dcenter.ums.security.core.api.logout.DefaultLogoutSuccessHandler;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.auth.filter.AjaxOrFormRequestFilter;
import top.dcenter.ums.security.core.auth.provider.UsernamePasswordAuthenticationProvider;
import top.dcenter.ums.security.core.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.config.ClientAutoConfigurerAware;
import top.dcenter.ums.security.core.config.CsrfAutoConfigurerAware;
import top.dcenter.ums.security.core.config.RememberMeAutoConfigurerAware;
import top.dcenter.ums.security.core.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.config.SessionAutoConfigurerAware;
import top.dcenter.ums.security.core.config.SmsCodeLoginAuthenticationAutoConfigurerAware;
import top.dcenter.ums.security.core.config.ValidateCodeAutoConfigurerAware;
import top.dcenter.ums.security.core.properties.ClientProperties;

@Configuration
@EnableWebSecurity
@AutoConfigureAfter(value={SecurityAutoConfiguration.class, SmsCodeLoginAuthenticationAutoConfigurerAware.class, ClientAutoConfigurerAware.class, CsrfAutoConfigurerAware.class, RememberMeAutoConfigurerAware.class, SessionAutoConfigurerAware.class, ValidateCodeAutoConfigurerAware.class})
public class SecurityCoreAutoConfigurer
extends WebSecurityConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SecurityCoreAutoConfigurer.class);
    private final ClientProperties clientProperties;
    private final BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final ObjectMapper objectMapper;
    private final UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider;
    private final DefaultLogoutSuccessHandler defaultLogoutSuccessHandler;
    private final PasswordEncoder passwordEncoder;
    @Autowired(required=false)
    private Map<String, HttpSecurityAware> webSecurityConfigurerMap;
    @Autowired(required=false)
    private UmsUserDetailsService umsUserDetailsService;

    public SecurityCoreAutoConfigurer(ClientProperties clientProperties, BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, ObjectMapper objectMapper, UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider, DefaultLogoutSuccessHandler defaultLogoutSuccessHandler, PasswordEncoder passwordEncoder) {
        this.clientProperties = clientProperties;
        this.baseAuthenticationSuccessHandler = baseAuthenticationSuccessHandler;
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.objectMapper = objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.usernamePasswordAuthenticationProvider = usernamePasswordAuthenticationProvider;
        this.defaultLogoutSuccessHandler = defaultLogoutSuccessHandler;
        this.passwordEncoder = passwordEncoder;
    }

    public void configure(WebSecurity web) {
        String[] ignoringUrls = this.clientProperties.getIgnoringUrls();
        web.ignoring().antMatchers(Objects.requireNonNullElseGet(ignoringUrls, () -> new String[0]));
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (this.umsUserDetailsService == null) {
            throw new RuntimeException("\u5fc5\u987b\u5b9e\u73b0 UmsUserDetailsService \u6216 top.dcenter.security.social.api.service.UmsSocialUserDetailsService \u62bd\u8c61\u7c7b");
        }
        auth.userDetailsService((UserDetailsService)this.umsUserDetailsService).passwordEncoder(this.passwordEncoder);
    }

    protected void configure(HttpSecurity http) throws Exception {
        HashMap<String, Set<UriHttpMethodTuple>> authorizeRequestMap = new HashMap<String, Set<UriHttpMethodTuple>>(16);
        HashMap<String, Map<UriHttpMethodTuple, Set<String>>> authorizeRequestMapPlus = new HashMap<String, Map<UriHttpMethodTuple, Set<String>>>(16);
        this.groupingAuthorizeRequestUris(http, authorizeRequestMap, authorizeRequestMapPlus);
        UriHttpMethodTuple[] permitAllArray = this.set2ArrayByType(authorizeRequestMap, "permitAll");
        UriHttpMethodTuple[] denyAllArray = this.set2ArrayByType(authorizeRequestMap, "denyAll");
        UriHttpMethodTuple[] anonymousArray = this.set2ArrayByType(authorizeRequestMap, "anonymous");
        UriHttpMethodTuple[] authenticatedArray = this.set2ArrayByType(authorizeRequestMap, "authenticated");
        UriHttpMethodTuple[] fullyAuthenticatedArray = this.set2ArrayByType(authorizeRequestMap, "fullyAuthenticated");
        UriHttpMethodTuple[] rememberMeArray = this.set2ArrayByType(authorizeRequestMap, "rememberMe");
        UriHttpMethodTuple[] accessArray = this.set2ArrayByType(authorizeRequestMap, "access");
        Map<UriHttpMethodTuple, String[]> hasRoleMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasRole");
        Map<UriHttpMethodTuple, String[]> hasAnyRoleMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasAnyRole");
        Map<UriHttpMethodTuple, String[]> hasAuthorityMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasAuthority");
        Map<UriHttpMethodTuple, String[]> hasAnyAuthorityMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasAnyAuthority");
        Map<UriHttpMethodTuple, String[]> hasIpAddressMap = this.toMapPlusByType(authorizeRequestMapPlus, "hasIpAddress");
        http.addFilterBefore((Filter)new AjaxOrFormRequestFilter(this.objectMapper), CsrfFilter.class);
        String loginUnAuthenticationRoutingUrl = this.clientProperties.getLoginUnAuthenticationRoutingUrl();
        if (!this.clientProperties.getOpenAuthenticationRedirect().booleanValue()) {
            loginUnAuthenticationRoutingUrl = this.clientProperties.getLogoutUrl();
        }
        ((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)http.authenticationProvider((AuthenticationProvider)this.usernamePasswordAuthenticationProvider).formLogin().usernameParameter(this.clientProperties.usernameParameter).passwordParameter(this.clientProperties.passwordParameter).loginPage(loginUnAuthenticationRoutingUrl).failureUrl(this.clientProperties.getFailureUrl())).defaultSuccessUrl(this.clientProperties.getSuccessUrl())).loginProcessingUrl(this.clientProperties.getLoginProcessingUrl())).successHandler((AuthenticationSuccessHandler)this.baseAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.baseAuthenticationFailureHandler);
        this.anonymousConfigurer(http);
        this.urlAuthorizationConfigurer(http, permitAllArray, denyAllArray, anonymousArray, authenticatedArray, fullyAuthenticatedArray, rememberMeArray, accessArray, hasRoleMap, hasAnyRoleMap, hasAuthorityMap, hasAnyAuthorityMap, hasIpAddressMap);
        this.logoutConfigurer(http);
        if (this.clientProperties.getSameOrigin().booleanValue()) {
            http.headers().frameOptions().sameOrigin();
        }
        if (this.webSecurityConfigurerMap != null) {
            for (HttpSecurityAware postConfigurer : this.webSecurityConfigurerMap.values()) {
                postConfigurer.postConfigure(http);
            }
        }
    }

    private void anonymousConfigurer(HttpSecurity http) throws Exception {
        ClientProperties.AnonymousProperties anonymous = this.clientProperties.getAnonymous();
        String[] authorities = new String[anonymous.getAuthorities().size()];
        anonymous.getAuthorities().toArray(authorities);
        if (anonymous.getAnonymousIsOpen().booleanValue()) {
            http.anonymous().principal((Object)anonymous.getPrincipal()).authorities(authorities);
        } else {
            http.anonymous().disable();
        }
    }

    private void logoutConfigurer(HttpSecurity http) throws Exception {
        http.logout().logoutUrl(this.clientProperties.getLogoutUrl()).logoutSuccessHandler((LogoutSuccessHandler)this.defaultLogoutSuccessHandler).logoutSuccessUrl(this.clientProperties.getLogoutSuccessUrl()).deleteCookies(new String[]{this.clientProperties.getRememberMe().getRememberMeCookieName(), this.clientProperties.getSession().getSessionCookieName()}).clearAuthentication(true).invalidateHttpSession(true);
    }

    private void urlAuthorizationConfigurer(HttpSecurity http, UriHttpMethodTuple[] permitAllArray, UriHttpMethodTuple[] denyAllArray, UriHttpMethodTuple[] anonymousArray, UriHttpMethodTuple[] authenticatedArray, UriHttpMethodTuple[] fullyAuthenticatedArray, UriHttpMethodTuple[] rememberMeArray, UriHttpMethodTuple[] accessArray, Map<UriHttpMethodTuple, String[]> hasRoleMap, Map<UriHttpMethodTuple, String[]> hasAnyRoleMap, Map<UriHttpMethodTuple, String[]> hasAuthorityMap, Map<UriHttpMethodTuple, String[]> hasAnyAuthorityMap, Map<UriHttpMethodTuple, String[]> hasIpAddressMap) throws Exception {
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry = http.authorizeRequests();
        this.setAuthorizeRequest(registry, permitAllArray, "permitAll");
        this.setAuthorizeRequest(registry, denyAllArray, "denyAll");
        this.setAuthorizeRequest(registry, anonymousArray, "anonymous");
        this.setAuthorizeRequest(registry, authenticatedArray, "authenticated");
        this.setAuthorizeRequest(registry, fullyAuthenticatedArray, "fullyAuthenticated");
        this.setAuthorizeRequest(registry, rememberMeArray, "rememberMe");
        this.setAuthorizeRequestPlus(registry, hasRoleMap, "hasRole");
        this.setAuthorizeRequestPlus(registry, hasAnyRoleMap, "hasAnyRole");
        this.setAuthorizeRequestPlus(registry, hasAuthorityMap, "hasAuthority");
        this.setAuthorizeRequestPlus(registry, hasAnyAuthorityMap, "hasAnyAuthority");
        this.setAuthorizeRequestPlus(registry, hasIpAddressMap, "hasIpAddress");
        if (accessArray.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (UriHttpMethodTuple tuple : accessArray) {
                if (tuple == null || !StringUtils.isNotBlank((CharSequence)tuple.getUri())) continue;
                sb.append(tuple).append(" and ");
            }
            int interceptLen = 5;
            if (sb.length() > interceptLen) {
                sb.setLength(sb.length() - interceptLen);
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.anyRequest()).access(sb.toString());
                return;
            }
        }
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.anyRequest()).authenticated();
    }

    private void setAuthorizeRequestPlus(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry, Map<UriHttpMethodTuple, String[]> uriHttpMethodTupleMap, String authorizeRequestType) {
        switch (authorizeRequestType) {
            case "hasRole": {
                uriHttpMethodTupleMap.forEach((tuple, roleArr) -> {
                    for (String role : roleArr) {
                        HttpMethod method = tuple.getMethod();
                        if (method == null) {
                            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).hasRole(role);
                            continue;
                        }
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).hasRole(role);
                    }
                });
                break;
            }
            case "hasAnyRole": {
                uriHttpMethodTupleMap.forEach((tuple, roleArr) -> {
                    HttpMethod method = tuple.getMethod();
                    if (method == null) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).hasAnyRole(roleArr);
                    } else {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).hasAnyRole(roleArr);
                    }
                });
                break;
            }
            case "hasAuthority": {
                uriHttpMethodTupleMap.forEach((tuple, roleArr) -> {
                    for (String role : roleArr) {
                        HttpMethod method = tuple.getMethod();
                        if (method == null) {
                            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).hasAuthority(role);
                            continue;
                        }
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).hasAuthority(role);
                    }
                });
                break;
            }
            case "hasAnyAuthority": {
                uriHttpMethodTupleMap.forEach((tuple, roleArr) -> {
                    HttpMethod method = tuple.getMethod();
                    if (method == null) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).hasAnyAuthority(roleArr);
                    } else {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).hasAnyAuthority(roleArr);
                    }
                });
                break;
            }
            case "hasIpAddress": {
                uriHttpMethodTupleMap.forEach((tuple, ipAddress) -> {
                    for (String ip : ipAddress) {
                        HttpMethod method = tuple.getMethod();
                        if (method == null) {
                            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).hasIpAddress(ip);
                            continue;
                        }
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).hasIpAddress(ip);
                    }
                });
                break;
            }
            default: {
                String msg = String.format("\u6743\u9650\u7c7b\u578b %s \u9519\u8bef", authorizeRequestType);
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
    }

    private void setAuthorizeRequest(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry, UriHttpMethodTuple[] tuples, String authorizeRequestType) {
        switch (authorizeRequestType) {
            case "permitAll": {
                Arrays.stream(tuples).forEach(tuple -> {
                    HttpMethod method = tuple.getMethod();
                    if (method == null) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).permitAll();
                    } else {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).permitAll();
                    }
                });
                break;
            }
            case "denyAll": {
                Arrays.stream(tuples).forEach(tuple -> {
                    HttpMethod method = tuple.getMethod();
                    if (method == null) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).denyAll();
                    } else {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).denyAll();
                    }
                });
                break;
            }
            case "anonymous": {
                Arrays.stream(tuples).forEach(tuple -> {
                    HttpMethod method = tuple.getMethod();
                    if (method == null) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).anonymous();
                    } else {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).anonymous();
                    }
                });
                break;
            }
            case "authenticated": {
                Arrays.stream(tuples).forEach(tuple -> {
                    HttpMethod method = tuple.getMethod();
                    if (method == null) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).authenticated();
                    } else {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).authenticated();
                    }
                });
                break;
            }
            case "fullyAuthenticated": {
                Arrays.stream(tuples).forEach(tuple -> {
                    HttpMethod method = tuple.getMethod();
                    if (method == null) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).fullyAuthenticated();
                    } else {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).fullyAuthenticated();
                    }
                });
                break;
            }
            case "rememberMe": {
                Arrays.stream(tuples).forEach(tuple -> {
                    HttpMethod method = tuple.getMethod();
                    if (method == null) {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(new String[]{tuple.getUri()})).rememberMe();
                    } else {
                        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.antMatchers(method, new String[]{tuple.getUri()})).rememberMe();
                    }
                });
                break;
            }
            default: {
                String msg = String.format("\u6743\u9650\u7c7b\u578b %s \u9519\u8bef", authorizeRequestType);
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    private UriHttpMethodTuple[] set2ArrayByType(Map<String, Set<UriHttpMethodTuple>> authorizeRequestMap, String authorizeRequestType) {
        Set<UriHttpMethodTuple> set = authorizeRequestMap.get(authorizeRequestType);
        if (set != null) {
            Object[] uriArray = new UriHttpMethodTuple[set.size()];
            set.toArray(uriArray);
            if (log.isDebugEnabled()) {
                log.debug("{} = {}", (Object)authorizeRequestType, (Object)Arrays.toString(uriArray));
            }
            return uriArray;
        }
        return new UriHttpMethodTuple[0];
    }

    private Map<UriHttpMethodTuple, String[]> toMapPlusByType(Map<String, Map<UriHttpMethodTuple, Set<String>>> authorizeRequestMap, String authorizeRequestType) {
        Map<UriHttpMethodTuple, Set<String>> map = authorizeRequestMap.get(authorizeRequestType);
        if (map != null) {
            return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                HashSet value = (HashSet)entry.getValue();
                if (value == null) {
                    value = new HashSet();
                }
                int length = value.size();
                String[] authorityArr = new String[length];
                return value.toArray(authorityArr);
            }));
        }
        return new HashMap<UriHttpMethodTuple, String[]>(0);
    }

    private void groupingAuthorizeRequestUris(@NonNull HttpSecurity http, @NonNull Map<String, Set<UriHttpMethodTuple>> targetAuthorizeRequestMap, @NonNull Map<String, Map<UriHttpMethodTuple, Set<String>>> targetAuthorizeRequestMapPlus) throws Exception {
        if (this.webSecurityConfigurerMap != null) {
            for (HttpSecurityAware configurer : this.webSecurityConfigurerMap.values()) {
                configurer.preConfigure(http);
                Map<String, Map<UriHttpMethodTuple, Set<String>>> authorizeRequestMap = configurer.getAuthorizeRequestMap();
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "permitAll");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "denyAll");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "anonymous");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "authenticated");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "fullyAuthenticated");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "rememberMe");
                this.groupByMap(targetAuthorizeRequestMap, authorizeRequestMap, "access");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasRole");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasAnyRole");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasAuthority");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasAnyAuthority");
                this.groupByMapPlus(targetAuthorizeRequestMapPlus, authorizeRequestMap, "hasIpAddress");
            }
            ApplicationContext applicationContext = this.getApplicationContext();
            WebApplicationContext servletContext = (WebApplicationContext)applicationContext;
            Objects.requireNonNull(servletContext.getServletContext()).setAttribute("SERVLET_CONTEXT_AUTHORIZE_REQUESTS_MAP_KEY", targetAuthorizeRequestMap);
        }
    }

    private void groupByMap(@NonNull Map<String, Set<UriHttpMethodTuple>> targetAuthorizeRequestMap, @Nullable Map<String, Map<UriHttpMethodTuple, Set<String>>> srcAuthorizeRequestMap, @NonNull String authorizeRequestType) {
        if (srcAuthorizeRequestMap != null) {
            Map<UriHttpMethodTuple, Set<String>> stringSetMap = srcAuthorizeRequestMap.get(authorizeRequestType);
            if (stringSetMap == null) {
                return;
            }
            Set<UriHttpMethodTuple> uriSet = stringSetMap.keySet();
            targetAuthorizeRequestMap.compute(authorizeRequestType, (k, v) -> {
                if (v == null) {
                    v = new HashSet(uriSet.size());
                }
                v.addAll(uriSet);
                return v;
            });
        }
    }

    private void groupByMapPlus(@NonNull Map<String, Map<UriHttpMethodTuple, Set<String>>> targetAuthorizeRequestMap, @Nullable Map<String, Map<UriHttpMethodTuple, Set<String>>> srcAuthorizeRequestMap, @NonNull String authorizeRequestType) {
        if (srcAuthorizeRequestMap != null) {
            Map<UriHttpMethodTuple, Set<String>> map = srcAuthorizeRequestMap.get(authorizeRequestType);
            if (map == null) {
                map = new HashMap<UriHttpMethodTuple, Set<String>>(0);
            }
            Map<UriHttpMethodTuple, Set<String>> uriAuthorizeMap = map;
            targetAuthorizeRequestMap.compute(authorizeRequestType, (k, v) -> {
                if (v == null) {
                    v = new HashMap(uriAuthorizeMap.size());
                }
                v.putAll(uriAuthorizeMap);
                return v;
            });
        }
    }
}

