/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import top.dcenter.ums.security.core.api.rememberme.repository.BasedRememberMeTokenRepositoryFactory;
import top.dcenter.ums.security.core.auth.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.auth.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.auth.rememberme.repository.JdbcTokenRepositoryFactory;

@Configuration
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class, SecurityAutoConfiguration.class})
public class SecurityRememberMeAutoConfiguration {
    private final DataSource dataSource;

    public SecurityRememberMeAutoConfiguration(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.rememberme.repository.BasedRememberMeTokenRepositoryFactory"})
    public BasedRememberMeTokenRepositoryFactory userTokenRepositoryFactory() {
        return new JdbcTokenRepositoryFactory(this.dataSource);
    }

    @Bean
    public PersistentTokenRepository persistentTokenRepository() {
        return this.userTokenRepositoryFactory().getPersistentTokenRepository();
    }
}

