/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.session.SessionManagementFilter;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.session.strategy.DefaultRedirectInvalidSessionStrategy;
import top.dcenter.ums.security.core.api.session.strategy.EnhanceConcurrentControlAuthenticationStrategy;
import top.dcenter.ums.security.core.auth.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.auth.config.SecuritySessionAutoConfiguration;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.auth.session.filter.SessionEnhanceCheckFilter;
import top.dcenter.ums.security.core.auth.session.strategy.ClientExpiredSessionStrategy;

@Configuration
@AutoConfigureAfter(value={SecuritySessionAutoConfiguration.class, PropertiesAutoConfiguration.class})
public class SessionAutoConfigurerAware
implements HttpSecurityAware {
    private final ClientProperties clientProperties;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final SessionEnhanceCheckFilter sessionEnhanceCheckFilter;
    private final DefaultRedirectInvalidSessionStrategy defaultRedirectInvalidSessionStrategy;
    private final ObjectMapper objectMapper;
    private final EnhanceConcurrentControlAuthenticationStrategy enhanceConcurrentControlAuthenticationStrategy;

    public SessionAutoConfigurerAware(ClientProperties clientProperties, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, SessionEnhanceCheckFilter sessionEnhanceCheckFilter, DefaultRedirectInvalidSessionStrategy defaultRedirectInvalidSessionStrategy, ObjectMapper objectMapper, EnhanceConcurrentControlAuthenticationStrategy enhanceConcurrentControlAuthenticationStrategy) {
        this.clientProperties = clientProperties;
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.sessionEnhanceCheckFilter = sessionEnhanceCheckFilter;
        this.defaultRedirectInvalidSessionStrategy = defaultRedirectInvalidSessionStrategy;
        this.objectMapper = objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.enhanceConcurrentControlAuthenticationStrategy = enhanceConcurrentControlAuthenticationStrategy;
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
    }

    public void postConfigure(HttpSecurity http) {
    }

    public void preConfigure(HttpSecurity http) throws Exception {
        http.addFilterAfter((Filter)this.sessionEnhanceCheckFilter, SessionManagementFilter.class);
        http.sessionManagement().sessionCreationPolicy(this.clientProperties.getSession().getSessionCreationPolicy()).sessionAuthenticationFailureHandler((AuthenticationFailureHandler)this.baseAuthenticationFailureHandler).sessionAuthenticationStrategy((SessionAuthenticationStrategy)this.enhanceConcurrentControlAuthenticationStrategy).sessionAuthenticationErrorUrl(this.clientProperties.getLoginPage()).invalidSessionStrategy((InvalidSessionStrategy)this.defaultRedirectInvalidSessionStrategy).enableSessionUrlRewriting(this.clientProperties.getSession().getEnableSessionUrlRewriting().booleanValue());
        if (this.clientProperties.getSession().getSessionNumberControl().booleanValue()) {
            http.sessionManagement().maximumSessions(this.clientProperties.getSession().getMaximumSessions().intValue()).maxSessionsPreventsLogin(this.clientProperties.getSession().getMaxSessionsPreventsLogin().booleanValue()).expiredSessionStrategy((SessionInformationExpiredStrategy)new ClientExpiredSessionStrategy(this.clientProperties, this.objectMapper));
        }
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        HashMap<UriHttpMethodTuple, Object> permitAllMap = new HashMap<UriHttpMethodTuple, Object>(16);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.GET, (String)this.clientProperties.getSession().getInvalidSessionUrl()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.GET, (String)this.clientProperties.getSession().getInvalidSessionOfConcurrentUrl()), null);
        HashMap<String, Map<UriHttpMethodTuple, Set<String>>> resultMap = new HashMap<String, Map<UriHttpMethodTuple, Set<String>>>(1);
        resultMap.put("permitAll", permitAllMap);
        return resultMap;
    }
}

