/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.auth.config.ValidateCodeBeanAutoConfiguration;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeFilter;

@Configuration
@AutoConfigureAfter(value={ValidateCodeBeanAutoConfiguration.class})
public class ValidateCodeAutoConfigurerAware
implements HttpSecurityAware {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeAutoConfigurerAware.class);
    private final ValidateCodeProperties validateCodeProperties;
    private final ValidateCodeFilter validateCodeFilter;

    public ValidateCodeAutoConfigurerAware(ValidateCodeProperties validateCodeProperties, ValidateCodeFilter validateCodeFilter) {
        this.validateCodeProperties = validateCodeProperties;
        this.validateCodeFilter = validateCodeFilter;
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
    }

    public void postConfigure(HttpSecurity http) {
        http.addFilterBefore((Filter)this.validateCodeFilter, AbstractPreAuthenticatedProcessingFilter.class);
    }

    public void preConfigure(HttpSecurity http) {
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        HashMap<UriHttpMethodTuple, Object> permitAllMap = new HashMap<UriHttpMethodTuple, Object>(16);
        ValidateCodeProperties.SliderCodeProperties slider = this.validateCodeProperties.getSlider();
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.GET, (String)(this.validateCodeProperties.getGetValidateCodeUrlPrefix() + "/**")), null);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.POST, (String)slider.getSliderCheckUrl()), null);
        this.validateCodeProperties.getSms().getAuthUrls().forEach(uri -> permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.POST, (String)uri), null));
        this.validateCodeProperties.getImage().getAuthUrls().forEach(uri -> permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.POST, (String)uri), null));
        slider.getAuthUrls().forEach(uri -> permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.POST, (String)uri), null));
        this.validateCodeProperties.getSelection().getAuthUrls().forEach(uri -> permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.POST, (String)uri), null));
        this.validateCodeProperties.getTrack().getAuthUrls().forEach(uri -> permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.POST, (String)uri), null));
        this.validateCodeProperties.getCustomize().getAuthUrls().forEach(uri -> permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.POST, (String)uri), null));
        HashMap<String, Map<UriHttpMethodTuple, Set<String>>> resultMap = new HashMap<String, Map<UriHttpMethodTuple, Set<String>>>(1);
        resultMap.put("permitAll", permitAllMap);
        return resultMap;
    }
}

