/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.mobile;

import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.auth.mobile.SmsCodeLoginAuthenticationToken;

public class SmsCodeLoginAuthenticationProvider
implements AuthenticationProvider {
    private UmsUserDetailsService userDetailsService;

    public SmsCodeLoginAuthenticationProvider(UmsUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        SmsCodeLoginAuthenticationToken authenticationToken = (SmsCodeLoginAuthenticationToken)authentication;
        if (authentication.isAuthenticated()) {
            return authentication;
        }
        UserDetails user = this.userDetailsService.loadUserByUsername((String)authenticationToken.getPrincipal());
        if (user == null) {
            user = this.userDetailsService.registerUser((String)authenticationToken.getPrincipal());
        }
        SmsCodeLoginAuthenticationToken authenticationResult = new SmsCodeLoginAuthenticationToken(user, user.getAuthorities());
        authenticationResult.setDetails(authenticationToken.getDetails());
        return authenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return SmsCodeLoginAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

