/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.filter.redirect;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.Assert;
import top.dcenter.ums.security.core.oauth.filter.redirect.Auth2AuthorizationRequestResolver;
import top.dcenter.ums.security.core.oauth.justauth.Auth2RequestHolder;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;

public final class Auth2DefaultRequestResolver
implements Auth2AuthorizationRequestResolver {
    private static final String REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    private final AntPathRequestMatcher authorizationRequestMatcher;

    public Auth2DefaultRequestResolver(String authorizationRequestBaseUri) {
        Assert.hasText((String)authorizationRequestBaseUri, (String)"authorizationRequestBaseUri cannot be empty");
        this.authorizationRequestMatcher = new AntPathRequestMatcher(authorizationRequestBaseUri + "/{registrationId}");
    }

    @Override
    public Auth2DefaultRequest resolve(HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("state"))) {
            return null;
        }
        String registrationId = this.resolveRegistrationId(request);
        if (registrationId == null) {
            return null;
        }
        return this.resolve(request, registrationId);
    }

    @Override
    public Auth2DefaultRequest resolve(HttpServletRequest request, String registrationId) {
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("state"))) {
            return null;
        }
        if (registrationId == null) {
            return null;
        }
        return Auth2RequestHolder.getAuth2DefaultRequest(registrationId);
    }

    public String resolveRegistrationId(HttpServletRequest request) {
        if (this.authorizationRequestMatcher.matches(request)) {
            return (String)this.authorizationRequestMatcher.matcher(request).getVariables().get(REGISTRATION_ID_URI_VARIABLE_NAME);
        }
        return null;
    }
}

