/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.auth.config.ValidateCodeBeanAutoConfiguration;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;

@Configuration
@AutoConfigureAfter(value={ValidateCodeBeanAutoConfiguration.class})
@ConditionalOnMissingBean(type={"org.springframework.security.config.annotation.method.configuration.GlobalMethodSecurityConfiguration"})
public class UriAuthorizeAutoConfigurerAware
implements HttpSecurityAware {
    private static final Logger log = LoggerFactory.getLogger(UriAuthorizeAutoConfigurerAware.class);
    private final ClientProperties clientProperties;

    public UriAuthorizeAutoConfigurerAware(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
    }

    public void postConfigure(HttpSecurity http) {
    }

    public void preConfigure(HttpSecurity http) {
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        HashMap<UriHttpMethodTuple, Object> accessMap = new HashMap<UriHttpMethodTuple, Object>(16);
        String accessExp = this.clientProperties.getAccessExp();
        accessMap.put(UriHttpMethodTuple.tuple(null, (String)accessExp), null);
        HashMap<String, Map<UriHttpMethodTuple, Set<String>>> resultMap = new HashMap<String, Map<UriHttpMethodTuple, Set<String>>>(1);
        resultMap.put("access", accessMap);
        return resultMap;
    }
}

