/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.permission.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.AntPathMatcher;
import top.dcenter.ums.security.core.api.permission.service.UriAuthorizeService;
import top.dcenter.ums.security.core.permission.dto.UriResourcesDTO;
import top.dcenter.ums.security.core.permission.enums.PermissionSuffixType;
import top.dcenter.ums.security.core.util.ConvertUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public abstract class AbstractUriAuthorizeService
implements UriAuthorizeService,
InitializingBean {
    private static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    public static final String PERMISSION_DELIMITER = ",";
    protected volatile Map<String, Map<String, UriResourcesDTO>> rolesAuthorityMap;
    private volatile Map<String, Set<String>> uriAuthoritiesMap;
    protected AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final Object lock = new Object();

    @Override
    public boolean match(String pattern, String requestUri) {
        return this.antPathMatcher.match(pattern, requestUri);
    }

    @Override
    public boolean hasPermission(HttpServletRequest request, Authentication authentication, String uriAuthority) {
        String requestUri = MvcUtil.getUrlPathHelper().getPathWithinApplication(request);
        return this.hasPermission(authentication, requestUri, uriAuthority);
    }

    @Override
    public boolean hasPermission(Authentication authentication, HttpServletRequest request) {
        Set<String> userAuthoritySet;
        boolean isMatchByMethod;
        String requestUri = MvcUtil.getUrlPathHelper().getPathWithinApplication(request);
        Map uriAuthorityOfUserRoleMap = this.getUriAuthoritiesOfUserRole(authentication).orElse(new HashMap(0));
        String method = request.getMethod();
        Set userUriSet = uriAuthorityOfUserRoleMap.keySet();
        if (userUriSet.contains(requestUri) && (isMatchByMethod = this.isMatchByMethod(method, userAuthoritySet = (Set<String>)uriAuthorityOfUserRoleMap.get(requestUri)))) {
            return true;
        }
        userAuthoritySet = userUriSet.stream().filter(uri -> this.match((String)uri, requestUri)).flatMap(uri -> ((Set)uriAuthorityOfUserRoleMap.get(uri)).stream()).collect(Collectors.toSet());
        return this.isMatchByMethod(method, userAuthoritySet);
    }

    @Override
    public boolean hasPermission(Authentication authentication, String requestUri, String uriAuthority) {
        Map uriAuthorityMap = this.getUriAuthoritiesOfUserRole(authentication).orElse(new HashMap(0));
        Set<String> uriSet = uriAuthorityMap.keySet();
        if (this.isUriContainsInUriSet(uriSet, requestUri).booleanValue()) {
            return uriAuthorityMap.values().stream().anyMatch(authoritySet -> authoritySet.contains(uriAuthority));
        }
        return false;
    }

    @Override
    public Optional<Map<String, Set<String>>> getUriAuthoritiesOfUserRole(Authentication authentication) {
        if (authentication == null) {
            return Optional.of(Collections.emptyMap());
        }
        Set authoritySet = AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities());
        Set roleSet = authoritySet.stream().filter(authority -> authority.startsWith(DEFAULT_ROLE_PREFIX)).collect(Collectors.toSet());
        HashMap<String, Set<String>> uriAuthoritiesMap = new HashMap<String, Set<String>>(this.rolesAuthorityMap.size());
        this.rolesAuthorityMap.entrySet().stream().filter(map -> roleSet.contains(map.getKey())).map(Map.Entry::getValue).forEach(this.map2mapConsumer(uriAuthoritiesMap));
        return Optional.of(uriAuthoritiesMap);
    }

    @Override
    public Optional<Map<String, Set<String>>> getUriAuthoritiesOfAllRole() {
        return Optional.of(this.uriAuthoritiesMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRolesAuthorities() {
        Object object = this.lock;
        synchronized (object) {
            Map rolesAuthorityMap = this.getRolesAuthorities().orElse(new HashMap(0));
            HashMap<String, Set<String>> uriAuthoritiesMap = new HashMap<String, Set<String>>(rolesAuthorityMap.size());
            rolesAuthorityMap.values().forEach(this.map2mapConsumer(uriAuthoritiesMap));
            this.uriAuthoritiesMap = uriAuthoritiesMap;
            this.rolesAuthorityMap = rolesAuthorityMap;
        }
    }

    @Override
    public Boolean isUriContainsInUriSet(Set<String> uriSet, String requestUri) {
        return uriSet.contains(requestUri) || uriSet.stream().anyMatch(uri -> this.antPathMatcher.match(uri, requestUri));
    }

    public void afterPropertiesSet() {
        this.updateRolesAuthorities();
    }

    @NonNull
    private Consumer<Map<String, UriResourcesDTO>> map2mapConsumer(Map<String, Set<String>> uriAuthoritiesMap) {
        return map -> map.forEach((key, value) -> uriAuthoritiesMap.compute((String)key, (k, v) -> {
            if (v == null) {
                v = new HashSet<String>();
            }
            v.addAll(ConvertUtil.string2Set(value.getPermission(), PERMISSION_DELIMITER));
            return v;
        }));
    }

    private boolean isMatchByMethod(@NonNull String requestMethod, @Nullable Set<String> userAuthoritySet) {
        if (CollectionUtils.isEmpty(userAuthoritySet)) {
            return false;
        }
        String permissionSuffix = PermissionSuffixType.getPermissionSuffix(requestMethod);
        if (permissionSuffix == null) {
            return false;
        }
        return userAuthoritySet.stream().anyMatch(authority -> authority.endsWith(permissionSuffix));
    }

    @Override
    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }
}

