/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.slider;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.validate.code.AbstractValidateCodeProcessor;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeType;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCode;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

public class SliderCoderProcessor
extends AbstractValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(SliderCoderProcessor.class);
    private final ObjectMapper objectMapper;
    private final ValidateCodeProperties validateCodeProperties;

    public SliderCoderProcessor(ValidateCodeGeneratorHolder validateCodeGeneratorHolder, ObjectMapper objectMapper, ValidateCodeProperties validateCodeProperties) {
        super(validateCodeGeneratorHolder);
        this.objectMapper = objectMapper;
        this.validateCodeProperties = validateCodeProperties;
    }

    @Override
    public boolean sent(ServletWebRequest request, ValidateCode validateCode) {
        try {
            if (!(validateCode instanceof SliderCode)) {
                return false;
            }
            SliderCode sliderCode = (SliderCode)validateCode;
            HttpServletResponse response = request.getResponse();
            if (response == null) {
                return false;
            }
            String resultJson = this.objectMapper.writeValueAsString((Object)sliderCode);
            AuthenticationUtil.responseWithJson(response, HttpStatus.OK.value(), resultJson);
            if (log.isDebugEnabled()) {
                log.debug("\u53d1\u9001\u6ed1\u5757\u9a8c\u8bc1\u7801: sliderCode = {}", (Object)sliderCode.toString());
            }
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public ValidateCodeType getValidateCodeType() {
        return ValidateCodeType.SLIDER;
    }

    @Override
    public void validate(ServletWebRequest request) throws ValidateCodeException {
        boolean verify;
        HttpServletRequest req = request.getRequest();
        ValidateCodeType sliderType = ValidateCodeType.SLIDER;
        String sessionKey = sliderType.getSessionKey();
        HttpSession session = req.getSession();
        SliderCode sliderCodeInSession = (SliderCode)session.getAttribute(sessionKey);
        if (sliderCodeInSession == null) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), request.getSessionId());
        }
        if (sliderCodeInSession.getSecondCheck().booleanValue()) {
            this.defaultValidate(request, this.validateCodeProperties.getSlider().getTokenRequestParamName());
            return;
        }
        ValidateCodeProperties.SliderCodeProperties slider = this.validateCodeProperties.getSlider();
        String tokenRequestParamName = slider.getTokenRequestParamName();
        String xRequestParamName = slider.getXRequestParamName();
        String yRequestParamName = slider.getYRequestParamName();
        String token = request.getParameter(tokenRequestParamName);
        String x = request.getParameter(xRequestParamName);
        String y = request.getParameter(yRequestParamName);
        this.checkParam(sessionKey, session, req, !StringUtils.isNotBlank((CharSequence)token), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, tokenRequestParamName);
        this.checkParam(sessionKey, session, req, !StringUtils.isNotBlank((CharSequence)x), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, xRequestParamName);
        this.checkParam(sessionKey, session, req, !StringUtils.isNotBlank((CharSequence)y), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, yRequestParamName);
        token = token.trim();
        Integer locationX = Integer.parseInt(x);
        Integer locationY = Integer.parseInt(y);
        this.checkParam(sessionKey, session, req, sliderCodeInSession.isExpired(), ErrorCodeEnum.VALIDATE_CODE_EXPIRED, token);
        boolean bl = verify = sliderCodeInSession.getLocationY().equals(locationY) && Math.abs(sliderCodeInSession.getLocationX() - locationX) < 2;
        if (!verify) {
            if (!sliderCodeInSession.getReuse().booleanValue()) {
                session.removeAttribute(sessionKey);
            }
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_FAILURE, req.getRemoteAddr(), token);
        }
        sliderCodeInSession.setSecondCheck(true);
        sliderCodeInSession.setCode(ValidateCodeUtil.getUUID());
        sliderCodeInSession.setReuse(false);
        session.setAttribute(sessionKey, (Object)sliderCodeInSession);
    }

    private void checkParam(String sessionKey, HttpSession session, HttpServletRequest req, boolean condition, ErrorCodeEnum errorCodeEnum, String errorData) throws ValidateCodeException {
        if (condition) {
            session.removeAttribute(sessionKey);
            throw new ValidateCodeException(errorCodeEnum, req.getRemoteAddr(), errorData);
        }
    }
}

