/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.sms;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.dcenter.ums.security.core.api.validate.code.sms.SmsCodeSender;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

public class DefaultSmsCodeSender
implements SmsCodeSender {
    private static final Logger log = LoggerFactory.getLogger(DefaultSmsCodeSender.class);
    private final ValidateCodeProperties validateCodeProperties;

    public DefaultSmsCodeSender(ValidateCodeProperties validateCodeProperties) {
        this.validateCodeProperties = validateCodeProperties;
    }

    @Override
    public boolean sendSms(String mobile, String validateCode) {
        log.warn("\u4f60\u6b63\u5728\u901a\u8fc7\u9ed8\u8ba4\u5b9e\u73b0\u7684\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801, \u8bf7\u5b9e\u73b0 SmsCodeSender \u63a5\u53e3: \u9a8c\u8bc1\u7801={}", (Object)validateCode);
        return true;
    }

    @Override
    public ValidateCode getCode() {
        ValidateCodeProperties.SmsCodeProperties smsCodeProp = this.validateCodeProperties.getSms();
        int expireIn = smsCodeProp.getExpire();
        int codeLength = smsCodeProp.getLength();
        String code = ValidateCodeUtil.generateNumberVerifyCode(codeLength);
        return new ValidateCode(code, expireIn);
    }
}

