/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.job;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.zhyd.oauth.exception.AuthException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import top.dcenter.ums.security.core.oauth.entity.AuthTokenPo;
import top.dcenter.ums.security.core.oauth.enums.EnableRefresh;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJob;
import top.dcenter.ums.security.core.oauth.justauth.Auth2RequestHolder;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionRepository;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionTokenRepository;
import top.dcenter.ums.security.core.util.MvcUtil;

public class RefreshTokenJobImpl
implements RefreshTokenJob,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RefreshTokenJobImpl.class);
    public static final String REFRESH_TOKEN_JOB = "RefreshTokenJob:HashKey:lock";
    public static final Integer REFRESH_TOKEN_JOB_KEY_EXPIRED_IN = 6;
    private final UsersConnectionRepository usersConnectionRepository;
    private final UsersConnectionTokenRepository usersConnectionTokenRepository;
    private final Auth2Properties auth2Properties;
    private final ScheduledExecutorService accessTokenJobTaskExecutor;
    private final ExecutorService refreshTokenTaskExecutor;
    @Autowired(required=false)
    private RedisConnectionFactory redisConnectionFactory;

    public RefreshTokenJobImpl(UsersConnectionRepository usersConnectionRepository, UsersConnectionTokenRepository usersConnectionTokenRepository, Auth2Properties auth2Properties, @Qualifier(value="accessTokenJobTaskExecutor") ScheduledExecutorService accessTokenJobTaskExecutor, @Qualifier(value="refreshTokenTaskExecutor") ExecutorService refreshTokenTaskExecutor) {
        Assert.notNull((Object)accessTokenJobTaskExecutor, (String)"accessTokenJobTaskExecutor cannot be null");
        Assert.notNull((Object)refreshTokenTaskExecutor, (String)"refreshTokenTaskExecutor cannot be null");
        Assert.notNull((Object)usersConnectionRepository, (String)"usersConnectionRepository cannot be null");
        Assert.notNull((Object)usersConnectionTokenRepository, (String)"usersConnectionTokenRepository cannot be null");
        Assert.notNull((Object)auth2Properties, (String)"auth2Properties cannot be null");
        this.accessTokenJobTaskExecutor = accessTokenJobTaskExecutor;
        this.refreshTokenTaskExecutor = refreshTokenTaskExecutor;
        this.usersConnectionRepository = usersConnectionRepository;
        this.usersConnectionTokenRepository = usersConnectionTokenRepository;
        this.auth2Properties = auth2Properties;
    }

    @Override
    @Scheduled(cron="0 * 3 * * ?")
    public void refreshTokenJob() {
        this.accessTokenJobTaskExecutor.schedule(() -> {
            if (this.redisConnectionFactory != null) {
                this.distributedRefreshToken();
            } else {
                this.refreshToken();
            }
        }, 10L, TimeUnit.MILLISECONDS);
    }

    private void distributedRefreshToken() {
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            byte[] key = REFRESH_TOKEN_JOB.getBytes(StandardCharsets.UTF_8.name());
            long expiredIn = Duration.ofHours(REFRESH_TOKEN_JOB_KEY_EXPIRED_IN.intValue()).toSeconds();
            connection.expireAt(key, Instant.now().plusSeconds(expiredIn).toEpochMilli());
            Long count = this.usersConnectionTokenRepository.count();
            Integer batchCount = this.auth2Properties.getBatchCount();
            long total = count / (long)batchCount.intValue() + (long)(count % (long)batchCount.intValue() == 0L ? 0 : 1);
            int i = 0;
            while ((long)i < total) {
                byte[] field = Integer.toString(i).getBytes(StandardCharsets.UTF_8.name());
                Boolean lock = connection.hSetNX(key, field, "0".getBytes(StandardCharsets.UTF_8.name()));
                if (lock != null && lock.booleanValue()) {
                    this.refresh(batchCount, i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            log.error(String.format("\u5206\u5e03\u5f0f refreshToken \u5b9a\u65f6\u5237\u65b0\u4efb\u52a1\u5f02\u5e38, error=%s", e.getMessage()), (Throwable)e);
        }
    }

    private void refreshToken() {
        try {
            Long count = this.usersConnectionTokenRepository.count();
            Integer batchCount = this.auth2Properties.getBatchCount();
            long total = count / (long)batchCount.intValue() + (long)(count % (long)batchCount.intValue() == 0L ? 0 : 1);
            int i = 0;
            while ((long)i < total) {
                this.refresh(batchCount, i);
                ++i;
            }
        }
        catch (Exception e) {
            log.error(String.format("\u5355\u673a refreshToken \u5b9a\u65f6\u5237\u65b0\u4efb\u52a1\u5f02\u5e38, error=%s", e.getMessage()), (Throwable)e);
        }
    }

    private void refresh(Integer batchCount, int batch) throws Exception {
        long expiredTime = Instant.now().toEpochMilli() + Duration.ofHours(this.auth2Properties.getRemainingExpireIn().intValue()).toMillis();
        List<AuthTokenPo> authTokenPoList = this.usersConnectionTokenRepository.findAuthTokenByExpireTimeAndBetweenId(expiredTime, 1L + (long)batch * (long)batchCount.intValue(), ((long)batch + 1L) * (long)batchCount.intValue());
        authTokenPoList.forEach(token -> {
            Auth2DefaultRequest auth2DefaultRequest = Auth2RequestHolder.getAuth2DefaultRequest(token.getProviderId());
            this.refreshTokenTaskExecutor.execute(() -> this.getTokenAndUpdateAuthTokenPo((AuthTokenPo)((Object)token), auth2DefaultRequest));
        });
    }

    private void getTokenAndUpdateAuthTokenPo(@NonNull AuthTokenPo token, @Nullable Auth2DefaultRequest auth2DefaultRequest) {
        if (auth2DefaultRequest != null) {
            try {
                AuthTokenPo authTokenPo;
                try {
                    authTokenPo = auth2DefaultRequest.refreshToken(token);
                }
                catch (Exception e) {
                    if (e instanceof AuthException) {
                        String msg = String.format("RefreshToken \u7b2c\u4e09\u65b9 %s \u4e0d\u652f\u6301: tokenId=%s", token.getProviderId(), token.getId());
                        log.info(msg);
                        AuthTokenPo authTokenPo2 = token;
                        authTokenPo2.setEnableRefresh(EnableRefresh.NO);
                        this.usersConnectionTokenRepository.updateEnableRefreshByTokenId(EnableRefresh.NO, token.getId());
                    } else {
                        String msg = String.format("RefreshToken \u5931\u8d25: tokenId=%s, error=%s", token.getId(), e.getMessage());
                        log.error(msg, (Throwable)e);
                    }
                    return;
                }
                this.updateAuthTokenPo(authTokenPo);
            }
            catch (Exception e) {
                String msg = String.format("RefreshToken \u5931\u8d25: tokenId=%s, error=%s", token.getId(), e.getMessage());
                log.error(msg, (Throwable)e);
            }
        } else {
            log.info("RefreshToken \u4e0d\u652f\u6301: providerId={}, ", (Object)token.getProviderId());
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void updateAuthTokenPo(@NonNull AuthTokenPo token) throws Exception {
        this.usersConnectionTokenRepository.updateAuthToken(token);
        this.usersConnectionRepository.updateConnectionByTokenId(token);
    }

    public void afterPropertiesSet() throws Exception {
        String methodName = "refreshTokenJob";
        if (this.auth2Properties.getEnableRefreshTokenJob().booleanValue()) {
            MvcUtil.setScheduledCron(methodName, this.auth2Properties.getRefreshTokenJobCron(), this.getClass(), new Class[0]);
        }
    }
}

