/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.repository.jdbc.cache;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.dao.PessimisticLockingFailureException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import top.dcenter.ums.security.core.oauth.repository.jdbc.cache.IRedisHashCacheWriter;

class RedisHashCacheWriter
implements IRedisHashCacheWriter {
    private final RedisConnectionFactory connectionFactory;
    private final Duration sleepTime;

    RedisHashCacheWriter(RedisConnectionFactory connectionFactory) {
        this(connectionFactory, Duration.ZERO);
    }

    RedisHashCacheWriter(RedisConnectionFactory connectionFactory, Duration sleepTime) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        Assert.notNull((Object)sleepTime, (String)"SleepTime must not be null!");
        this.connectionFactory = connectionFactory;
        this.sleepTime = sleepTime;
    }

    public void put(@NonNull String name, @NonNull byte[] key, @NonNull byte[] value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.execute(name, connection -> {
            if (RedisHashCacheWriter.shouldExpireWithin(ttl)) {
                connection.set(key, value, Expiration.from((long)ttl.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS), RedisStringCommands.SetOption.upsert());
            } else {
                connection.set(key, value);
            }
            return "OK";
        });
    }

    @Override
    public void hPut(String name, byte[] key, byte[] field, byte[] value, Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"field must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.execute(name, connection -> {
            if (RedisHashCacheWriter.shouldExpireWithin(ttl)) {
                connection.multi();
                connection.expire(key, ttl.toSeconds());
                connection.hSet(key, field, value);
                connection.expire(key, ttl.toSeconds());
                connection.exec();
            } else {
                connection.hSet(key, field, value);
            }
            return "OK";
        });
    }

    public byte[] get(@NonNull String name, @NonNull byte[] key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.execute(name, connection -> connection.get(key));
    }

    @Override
    public byte[] hGet(String name, byte[] key, byte[] field) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)field, (String)"field must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.execute(name, connection -> connection.hGet(key, field));
    }

    public byte[] putIfAbsent(@NonNull String name, @NonNull byte[] key, @NonNull byte[] value, @Nullable Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.execute(name, connection -> {
            if (this.isLockingCacheWriter()) {
                this.doLock(name, (RedisConnection)connection);
            }
            try {
                if (Objects.requireNonNullElse(connection.setNX(key, value), Boolean.FALSE).booleanValue()) {
                    if (RedisHashCacheWriter.shouldExpireWithin(ttl)) {
                        connection.pExpire(key, ttl.toMillis());
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = connection.get(key);
                return byArray;
            }
            finally {
                if (this.isLockingCacheWriter()) {
                    this.doUnlock(name, (RedisConnection)connection);
                }
            }
        });
    }

    @Override
    public byte[] hPutIfAbsent(String name, byte[] key, byte[] field, byte[] value, Duration ttl) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"field must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        return this.execute(name, connection -> {
            if (this.isLockingCacheWriter()) {
                this.doLock(name, (RedisConnection)connection);
            }
            try {
                if (Objects.requireNonNullElse(connection.hSetNX(key, field, value), Boolean.FALSE).booleanValue()) {
                    if (RedisHashCacheWriter.shouldExpireWithin(ttl)) {
                        connection.pExpire(key, ttl.toMillis());
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                byte[] byArray = connection.hGet(key, field);
                return byArray;
            }
            finally {
                if (this.isLockingCacheWriter()) {
                    this.doUnlock(name, (RedisConnection)connection);
                }
            }
        });
    }

    public void remove(@NonNull String name, @NonNull byte[] key) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        this.execute(name, connection -> connection.del((byte[][])new byte[][]{key}));
    }

    @Override
    public void hRemove(String name, byte[] key, byte[] field) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)field, (String)"field must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        this.execute(name, connection -> connection.hDel(key, (byte[][])new byte[][]{field}));
    }

    public void clean(@NonNull String name, @NonNull byte[] pattern) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)pattern, (String)"Pattern must not be null!");
        this.execute(name, connection -> {
            boolean wasLocked = false;
            try {
                byte[][] keys;
                if (this.isLockingCacheWriter()) {
                    this.doLock(name, (RedisConnection)connection);
                    wasLocked = true;
                }
                if ((keys = (byte[][])Optional.ofNullable(connection.keys(pattern)).orElse(Collections.emptySet()).toArray((T[])new byte[0][])).length > 0) {
                    connection.del(keys);
                }
            }
            finally {
                if (wasLocked && this.isLockingCacheWriter()) {
                    this.doUnlock(name, (RedisConnection)connection);
                }
            }
            return "OK";
        });
    }

    void lock(String name) {
        this.execute(name, connection -> this.doLock(name, (RedisConnection)connection));
    }

    void unlock(String name) {
        this.executeLockFree(connection -> this.doUnlock(name, (RedisConnection)connection));
    }

    private Boolean doLock(String name, RedisConnection connection) {
        return connection.setNX(RedisHashCacheWriter.createCacheLockKey(name), new byte[0]);
    }

    private Long doUnlock(String name, RedisConnection connection) {
        return connection.del((byte[][])new byte[][]{RedisHashCacheWriter.createCacheLockKey(name)});
    }

    boolean doCheckLock(String name, RedisConnection connection) {
        return Objects.requireNonNullElse(connection.exists(RedisHashCacheWriter.createCacheLockKey(name)), Boolean.FALSE);
    }

    private boolean isLockingCacheWriter() {
        return !this.sleepTime.isZero() && !this.sleepTime.isNegative();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(String name, Function<RedisConnection, T> callback) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            this.checkAndPotentiallyWaitUntilUnlocked(name, connection);
            T t = callback.apply(connection);
            return t;
        }
    }

    private void executeLockFree(Consumer<RedisConnection> callback) {
        try (RedisConnection connection = this.connectionFactory.getConnection();){
            callback.accept(connection);
        }
    }

    private void checkAndPotentiallyWaitUntilUnlocked(String name, RedisConnection connection) {
        if (!this.isLockingCacheWriter()) {
            return;
        }
        try {
            while (this.doCheckLock(name, connection)) {
                Thread.sleep(this.sleepTime.toMillis());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new PessimisticLockingFailureException(String.format("Interrupted while waiting to unlock cache %s", name), (Throwable)ex);
        }
    }

    private static boolean shouldExpireWithin(@Nullable Duration ttl) {
        return ttl != null && !ttl.isZero() && !ttl.isNegative();
    }

    private static byte[] createCacheLockKey(String name) {
        return (name + "~lock").getBytes(StandardCharsets.UTF_8);
    }
}

