/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.web.util.UrlUtils;
import top.dcenter.ums.security.core.auth.filter.AjaxOrFormRequestFilter;
import top.dcenter.ums.security.core.util.ConvertUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public class RequestUtil {
    public static final String VALIDATE_JSON_PREFIX = "{";

    public static <T> T extractRequest2Object(HttpServletRequest request, ObjectMapper objectMapper, Class<T> clz) {
        try {
            byte[] bodies;
            if (request instanceof AjaxOrFormRequestFilter.AjaxOrFormRequest) {
                AjaxOrFormRequestFilter.AjaxOrFormRequest ajaxOrFormRequest = (AjaxOrFormRequestFilter.AjaxOrFormRequest)request;
                bodies = Objects.requireNonNullElse(ajaxOrFormRequest.getBody(), "".getBytes(StandardCharsets.UTF_8));
            } else {
                bodies = request.getInputStream().readAllBytes();
            }
            String requestBody = new String(bodies, StandardCharsets.UTF_8).trim();
            if (StringUtils.isBlank((CharSequence)requestBody)) {
                return null;
            }
            return RequestUtil.requestBody2Object(objectMapper, clz, requestBody);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T requestBody2Object(ObjectMapper objectMapper, Class<T> clz, String requestBody) throws JsonProcessingException {
        if (StringUtils.isBlank((CharSequence)requestBody)) {
            return null;
        }
        if (StringUtils.startsWith((CharSequence)requestBody, (CharSequence)VALIDATE_JSON_PREFIX)) {
            return (T)objectMapper.readValue(requestBody, clz);
        }
        Map<String, Object> map = ConvertUtil.string2JsonMap(requestBody, "&", "=");
        return (T)objectMapper.readValue(map.toString(), clz);
    }

    public static String getRequestUri(String url) {
        String servletContextPath;
        int endIndex;
        if (UrlUtils.isAbsoluteUrl((String)url)) {
            url = url.replaceFirst("\\A[a-z0-9.+-]+://", "");
            url = url.substring(url.indexOf("/"));
        }
        if ((endIndex = url.indexOf("?")) > 0) {
            url = url.substring(0, endIndex);
        }
        if ((endIndex = url.indexOf("#")) > 0) {
            url = url.substring(0, endIndex);
        }
        if (url.startsWith(servletContextPath = MvcUtil.getServletContextPath())) {
            url = url.substring(servletContextPath.length());
        }
        return url;
    }
}

