/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.session.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.session.SessionEnhanceCheckService;
import top.dcenter.ums.security.core.exception.SessionEnhanceCheckException;
import top.dcenter.ums.security.core.util.AuthenticationUtil;

public class SessionEnhanceCheckFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(SessionEnhanceCheckFilter.class);
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final SessionEnhanceCheckService sessionEnhanceCheckService;
    private final AntPathMatcher pathMatcher;

    public SessionEnhanceCheckFilter(BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, SessionEnhanceCheckService sessionEnhanceCheckService) {
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.sessionEnhanceCheckService = sessionEnhanceCheckService;
        this.pathMatcher = new AntPathMatcher();
    }

    protected void doFilterInternal(HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        String checkValue;
        HttpSession session = request.getSession(false);
        if (this.sessionEnhanceCheckService != null && session != null && !AuthenticationUtil.isPermitUri(request, session, this.pathMatcher) && (checkValue = (String)session.getAttribute("SESSION_ENHANCE_CHECK_KEY")) != null && !this.sessionEnhanceCheckService.sessionEnhanceCheck(checkValue, request)) {
            log.warn("session\u88ab\u52ab\u6301: ip={}, ua={}, sid={}, uri={}, checkValue={}", new Object[]{request.getRemoteAddr(), request.getHeader("User-Agent"), session.getId(), request.getRequestURI(), checkValue});
            this.baseAuthenticationFailureHandler.onAuthenticationFailure(request, response, new SessionEnhanceCheckException(ErrorCodeEnum.SESSION_ENHANCE_CHECK, session.getId(), checkValue));
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

