/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.enums;

import org.springframework.lang.NonNull;

public enum PermissionSuffixType {
    LIST("GET"){

        @Override
        public String getPermissionSuffix() {
            return ":list";
        }
    }
    ,
    ADD("POST"){

        @Override
        public String getPermissionSuffix() {
            return ":add";
        }
    }
    ,
    EDIT("PUT"){

        @Override
        public String getPermissionSuffix() {
            return ":edit";
        }
    }
    ,
    DELETE("DELETE"){

        @Override
        public String getPermissionSuffix() {
            return ":del";
        }
    }
    ,
    HEAD("HEAD"){

        @Override
        public String getPermissionSuffix() {
            return ":head";
        }
    }
    ,
    PATCH("PATCH"){

        @Override
        public String getPermissionSuffix() {
            return ":patch";
        }
    }
    ,
    OPTIONS("OPTIONS"){

        @Override
        public String getPermissionSuffix() {
            return ":options";
        }
    }
    ,
    TRACE("TRACE"){

        @Override
        public String getPermissionSuffix() {
            return ":trace";
        }
    };

    private String method;

    private PermissionSuffixType(String method) {
        this.method = method;
    }

    public abstract String getPermissionSuffix();

    public static String getPermissionSuffix(@NonNull String method) {
        PermissionSuffixType permissionType = PermissionSuffixType.getPermissionType(method);
        if (permissionType == null) {
            return null;
        }
        return permissionType.getPermissionSuffix();
    }

    public static PermissionSuffixType getPermissionType(@NonNull String method) {
        PermissionSuffixType[] types;
        for (PermissionSuffixType type : types = PermissionSuffixType.values()) {
            if (!type.method.equals(method.toUpperCase())) continue;
            return type;
        }
        return null;
    }

    public String getMethod() {
        return this.method;
    }
}

