/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

public class ImageUtil {
    public static String outputVerifyImage(int w, int h, File outputFile, int verifySize) throws IOException {
        String verifyCode = ValidateCodeUtil.generateVerifyCode(verifySize);
        ImageUtil.outputImage(w, h, outputFile, verifyCode);
        return verifyCode;
    }

    public static String outputVerifyImage(int w, int h, OutputStream os, int verifySize) throws IOException {
        String verifyCode = ValidateCodeUtil.generateVerifyCode(verifySize);
        ImageUtil.outputImage(w, h, os, verifyCode);
        return verifyCode;
    }

    public static void outputImage(int w, int h, File outputFile, String code) throws IOException {
        if (outputFile == null) {
            return;
        }
        File dir = outputFile.getParentFile();
        try {
            boolean newFile;
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!(newFile = outputFile.createNewFile())) {
                throw new IOException("\u8f93\u51fa\u56fe\u7247\u5931\u8d25");
            }
            FileOutputStream fos = new FileOutputStream(outputFile);
            ImageUtil.outputImage(w, h, fos, code);
            fos.close();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static void outputImage(int w, int h, OutputStream os, String code) throws IOException {
        BufferedImage image = ImageUtil.getBufferedImage(w, h, code);
        ImageIO.write((RenderedImage)image, "jpg", os);
    }

    public static BufferedImage getBufferedImage(int width, int height, String code) {
        int verifySize = code.length();
        int tempWidth = height * 45 / 10;
        width = Math.max(width, tempWidth);
        BufferedImage image = new BufferedImage(width, height, 1);
        Random rand = new Random();
        Graphics2D g2 = image.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = new Color[5];
        Color[] colorSpaces = new Color[]{Color.WHITE, Color.CYAN, Color.GRAY, Color.LIGHT_GRAY, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.YELLOW};
        float[] fractions = new float[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colorSpaces[rand.nextInt(colorSpaces.length)];
            fractions[i] = rand.nextFloat();
        }
        Arrays.sort(fractions);
        g2.setColor(Color.GRAY);
        g2.fillRect(0, 0, width, height);
        Random random = new Random();
        Color c = ImageUtil.getRandColor(200, 250, random);
        g2.setColor(c);
        g2.fillRect(0, 2, width, height - 4);
        g2.setColor(ImageUtil.getRandColor(160, 200, random));
        int lineLength = 20;
        for (int i = 0; i < lineLength; ++i) {
            int x = random.nextInt(width - 1);
            int y = random.nextInt(height - 1);
            int xl = random.nextInt(6) + 1;
            int yl = random.nextInt(12) + 1;
            g2.drawLine(x, y, x + xl + 40, y + yl + 20);
        }
        float yawpRate = 0.05f;
        int area = (int)(yawpRate * (float)width * (float)height);
        for (int i = 0; i < area; ++i) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int rgb = ImageUtil.getRandomIntColor(random);
            image.setRGB(x, y, rgb);
        }
        ImageUtil.shear(g2, width, height, c, random);
        g2.setColor(ImageUtil.getRandColor(100, 160, random));
        int yPending = (int)((float)height * 0.05f);
        int fontSize = height - yPending;
        Font font = new Font("Arial", 2, fontSize);
        g2.setFont(font);
        char[] chars = code.toCharArray();
        for (int i = 0; i < verifySize; ++i) {
            int xPending = (int)((float)width * 0.1f);
            int dynamicPending = (width - xPending) / verifySize * i;
            dynamicPending = i == 0 ? (dynamicPending += xPending) : (dynamicPending += xPending / 2);
            AffineTransform affine = new AffineTransform();
            affine.setToRotation(0.7853981633974483 * rand.nextDouble() * (double)(rand.nextBoolean() ? 1 : -1), (double)dynamicPending + (double)fontSize / 2.0, (double)(height - yPending) / 2.0);
            g2.setTransform(affine);
            g2.drawChars(chars, i, 1, dynamicPending, height / 2 + fontSize / 2 - yPending);
        }
        g2.dispose();
        return image;
    }

    private static Color getRandColor(int fc, int bc, Random random) {
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static int getRandomIntColor(Random random) {
        int[] rgb = ImageUtil.getRandomRgb(random);
        int color = 0;
        for (int c : rgb) {
            color <<= 8;
            color |= c;
        }
        return color;
    }

    private static int[] getRandomRgb(Random random) {
        int[] rgb = new int[3];
        for (int i = 0; i < rgb.length; ++i) {
            rgb[i] = random.nextInt(255);
        }
        return rgb;
    }

    private static void shear(Graphics g, int w1, int h1, Color color, Random random) {
        ImageUtil.shearX(g, w1, h1, color, true, random);
        ImageUtil.shearY(g, w1, h1, color, true, random);
    }

    private static void shearX(Graphics g, int w1, int h1, Color color, boolean borderGap, Random random) {
        int period = random.nextInt(2);
        boolean frames = true;
        int phase = random.nextInt(2);
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    private static void shearY(Graphics g, int w1, int h1, Color color, boolean borderGap, Random random) {
        int period = random.nextInt(40) + 10;
        int frames = 20;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }
}

