/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code;

import javax.servlet.http.HttpServletRequest;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.validate.code.ValidateCode;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeCacheType;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.exception.ValidateCodeException;

public interface ValidateCodeProcessor {
    public boolean produce(ServletWebRequest var1) throws ValidateCodeException;

    public ValidateCodeType getValidateCodeType();

    public ValidateCode generate(ServletWebRequest var1);

    public boolean save(ServletWebRequest var1, ValidateCode var2);

    public boolean sent(ServletWebRequest var1, ValidateCode var2);

    public void validate(ServletWebRequest var1) throws ValidateCodeException;

    default public void defaultValidate(ServletWebRequest request, String requestParamValidateCodeName, Class<? extends ValidateCode> validateCodeClass, ValidateCodeCacheType validateCodeCacheType, StringRedisTemplate stringRedisTemplate) throws ValidateCodeException {
        HttpServletRequest req = request.getRequest();
        ValidateCodeType validateCodeType = this.getValidateCodeType();
        ValidateCode codeInSession = validateCodeCacheType.getCodeInCache(request, validateCodeType, validateCodeClass, stringRedisTemplate);
        String codeInRequest = request.getParameter(requestParamValidateCodeName);
        if (codeInSession == null) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), codeInRequest);
        }
        if (!StringUtils.hasText((String)codeInRequest)) {
            validateCodeCacheType.removeCache(request, validateCodeType, stringRedisTemplate);
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, req.getRemoteAddr(), validateCodeType.name());
        }
        codeInRequest = codeInRequest.trim();
        if (codeInSession.isExpired()) {
            validateCodeCacheType.removeCache(request, validateCodeType, stringRedisTemplate);
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), codeInRequest);
        }
        if (!codeInRequest.equalsIgnoreCase(codeInSession.getCode())) {
            if (!codeInSession.getReuse().booleanValue()) {
                validateCodeCacheType.removeCache(request, validateCodeType, stringRedisTemplate);
            }
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_ERROR, req.getRemoteAddr(), codeInRequest);
        }
        validateCodeCacheType.removeCache(request, validateCodeType, stringRedisTemplate);
    }
}

