/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import top.dcenter.ums.security.core.oauth.config.Auth2AutoConfiguration;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJob;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJobImpl;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.ExecutorProperties;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionRepository;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionTokenRepository;

@Configuration
@ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={Auth2AutoConfiguration.class})
@EnableScheduling
public class ScheduleAutoConfiguration
implements SchedulingConfigurer,
DisposableBean {
    private final Auth2Properties auth2Properties;
    private final ExecutorProperties executorProperties;
    private ScheduledExecutorService accessTokenScheduledExecutorService;
    private ExecutorService updateConnectionExecutorService;
    private ExecutorService refreshTokenExecutorService;

    public ScheduleAutoConfiguration(Auth2Properties auth2Properties, ExecutorProperties executorProperties) {
        this.auth2Properties = auth2Properties;
        this.executorProperties = executorProperties;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.accessTokenScheduledExecutorService);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.job.RefreshTokenJob"})
    @ConditionalOnProperty(prefix="ums.oauth", name={"enableRefreshTokenJob"}, havingValue="true")
    public RefreshTokenJob refreshTokenJob(UsersConnectionTokenRepository usersConnectionTokenRepository, UsersConnectionRepository usersConnectionRepository, @Qualifier(value="accessTokenJobTaskExecutor") ScheduledExecutorService accessTokenJobTaskExecutor, @Qualifier(value="refreshTokenTaskExecutor") ExecutorService refreshTokenTaskExecutor) {
        return new RefreshTokenJobImpl(usersConnectionRepository, usersConnectionTokenRepository, this.auth2Properties, accessTokenJobTaskExecutor, refreshTokenTaskExecutor);
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enableRefreshTokenJob"}, havingValue="true")
    public ScheduledExecutorService accessTokenJobTaskExecutor() {
        ExecutorProperties.AccessTokenRefreshJobExecutorProperties accessTokenRefreshJob = this.executorProperties.getAccessTokenRefreshJob();
        MdcScheduledThreadPoolTaskExecutor scheduledThreadPoolExecutor = new MdcScheduledThreadPoolTaskExecutor(accessTokenRefreshJob.getCorePoolSize(), this.getThreadFactory(accessTokenRefreshJob.getPoolName()), accessTokenRefreshJob.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        scheduledThreadPoolExecutor.setKeepAliveTime(accessTokenRefreshJob.getKeepAliveTime().intValue(), accessTokenRefreshJob.getTimeUnit());
        this.accessTokenScheduledExecutorService = scheduledThreadPoolExecutor;
        return scheduledThreadPoolExecutor;
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enableRefreshTokenJob"}, havingValue="true")
    public ExecutorService refreshTokenTaskExecutor() {
        ExecutorProperties.RefreshTokenExecutorProperties refreshToken = this.executorProperties.getRefreshToken();
        MdcThreadPoolTaskExecutor threadPoolExecutor = new MdcThreadPoolTaskExecutor(refreshToken.getCorePoolSize(), refreshToken.getMaximumPoolSize(), refreshToken.getKeepAliveTime().intValue(), refreshToken.getTimeUnit(), new LinkedBlockingQueue<Runnable>(refreshToken.getBlockingQueueCapacity()), this.getThreadFactory(refreshToken.getPoolName()), refreshToken.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.refreshTokenExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    @Bean(destroyMethod="shutdown")
    public ExecutorService updateConnectionTaskExecutor() {
        ExecutorProperties.UserConnectionUpdateExecutorProperties userConnectionUpdate = this.executorProperties.getUserConnectionUpdate();
        MdcThreadPoolTaskExecutor threadPoolExecutor = new MdcThreadPoolTaskExecutor(userConnectionUpdate.getCorePoolSize(), userConnectionUpdate.getMaximumPoolSize(), userConnectionUpdate.getKeepAliveTime().intValue(), userConnectionUpdate.getTimeUnit(), new LinkedBlockingQueue<Runnable>(userConnectionUpdate.getBlockingQueueCapacity()), this.getThreadFactory(userConnectionUpdate.getPoolName()), userConnectionUpdate.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.updateConnectionExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    private ThreadFactory getThreadFactory(String poolName) {
        return new DefaultThreadFactory(poolName);
    }

    public void shutdown() throws Exception {
        if (this.updateConnectionExecutorService != null) {
            this.updateConnectionExecutorService.shutdown();
            this.updateConnectionExecutorService.awaitTermination(this.executorProperties.getUserConnectionUpdate().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.updateConnectionExecutorService.isTerminated()) {
                this.updateConnectionExecutorService.shutdownNow();
            }
        }
    }

    public void destroy() throws Exception {
        if (this.refreshTokenExecutorService != null) {
            this.refreshTokenExecutorService.shutdown();
            this.refreshTokenExecutorService.awaitTermination(this.executorProperties.getAccessTokenRefreshJob().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.refreshTokenExecutorService.isTerminated()) {
                this.refreshTokenExecutorService.shutdownNow();
            }
        }
        if (this.accessTokenScheduledExecutorService != null) {
            this.accessTokenScheduledExecutorService.shutdown();
            this.accessTokenScheduledExecutorService.awaitTermination(this.executorProperties.getAccessTokenRefreshJob().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.accessTokenScheduledExecutorService.isTerminated()) {
                this.accessTokenScheduledExecutorService.shutdownNow();
            }
        }
    }

    private static class MdcThreadPoolTaskExecutor
    extends ThreadPoolExecutor {
        Map<Object, Object> taskObjectMap = new ConcurrentHashMap<Object, Object>();

        public MdcThreadPoolTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        public MdcThreadPoolTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        }

        public MdcThreadPoolTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
        }

        public MdcThreadPoolTaskExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        @Override
        public void execute(@NonNull Runnable runnable) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(runnable, context);
            this.taskObjectMap.put(runnable, r);
            super.execute(r);
        }

        @Override
        @NonNull
        public Future<?> submit(@NonNull Runnable task) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(task, context);
            this.taskObjectMap.put(task, r);
            return super.submit(r);
        }

        @Override
        @NonNull
        public <T> Future<T> submit(@NonNull Callable<T> task) {
            Map context = MDC.getCopyOfContextMap();
            Callable<Object> c = () -> this.call(task, context);
            this.taskObjectMap.put(task, c);
            return super.submit(c);
        }

        @Override
        @NonNull
        public <T> Future<T> submit(Runnable task, T result) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(task, context);
            this.taskObjectMap.put(task, r);
            return super.submit(r, result);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(runnable, context);
            this.taskObjectMap.put(runnable, r);
            return super.newTaskFor(r, value);
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
            Map context = MDC.getCopyOfContextMap();
            Callable<Object> c = () -> this.call(callable, context);
            this.taskObjectMap.put(callable, c);
            return super.newTaskFor(c);
        }

        @Override
        @NonNull
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAny(tasks.stream().map(task -> this.convert((Callable)task, context)).collect(Collectors.toList()));
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAny(tasks.stream().map(task -> this.convert((Callable)task, context)).collect(Collectors.toList()), timeout, unit);
        }

        @Override
        @NonNull
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAll(tasks.stream().map(task -> this.convert((Callable)task, context)).collect(Collectors.toList()));
        }

        @Override
        @NonNull
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAll(tasks.stream().map(task -> this.convert((Callable)task, context)).collect(Collectors.toList()), timeout, unit);
        }

        @Override
        public boolean remove(Runnable task) {
            try {
                boolean bl = super.remove((Runnable)this.taskObjectMap.get(task));
                return bl;
            }
            finally {
                this.taskObjectMap.remove(task);
            }
        }

        private void run(Runnable runnable, Map<String, String> context) {
            MDC.setContextMap(context);
            try {
                runnable.run();
            }
            finally {
                this.taskObjectMap.remove(runnable);
                MDC.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <V> V call(Callable<V> task, Map<String, String> context) throws Exception {
            MDC.setContextMap(context);
            try {
                V v = task.call();
                return v;
            }
            finally {
                this.taskObjectMap.remove(task);
                MDC.clear();
            }
        }

        private <V> Callable<V> convert(Callable<V> task, Map<String, String> context) {
            Callable<Object> t = () -> this.call(task, context);
            this.taskObjectMap.put(task, t);
            return t;
        }
    }

    private static class MdcScheduledThreadPoolTaskExecutor
    extends ScheduledThreadPoolExecutor {
        Map<Object, Object> taskObjectMap = new ConcurrentHashMap<Object, Object>();

        public MdcScheduledThreadPoolTaskExecutor(int corePoolSize) {
            super(corePoolSize);
        }

        public MdcScheduledThreadPoolTaskExecutor(int corePoolSize, ThreadFactory threadFactory) {
            super(corePoolSize, threadFactory);
        }

        public MdcScheduledThreadPoolTaskExecutor(int corePoolSize, RejectedExecutionHandler handler) {
            super(corePoolSize, handler);
        }

        public MdcScheduledThreadPoolTaskExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, threadFactory, handler);
        }

        @Override
        @NonNull
        public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(command, context);
            this.taskObjectMap.put(command, r);
            return super.schedule(r, delay, unit);
        }

        @Override
        @NonNull
        public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            Map context = MDC.getCopyOfContextMap();
            Callable<Object> c = () -> this.call(callable, context);
            this.taskObjectMap.put(callable, c);
            return super.schedule(c, delay, unit);
        }

        @Override
        @NonNull
        public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(command, context);
            this.taskObjectMap.put(command, r);
            return super.scheduleAtFixedRate(r, initialDelay, period, unit);
        }

        @Override
        @NonNull
        public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(command, context);
            this.taskObjectMap.put(command, r);
            return super.scheduleWithFixedDelay(r, initialDelay, delay, unit);
        }

        @Override
        public void execute(Runnable command) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(command, context);
            this.taskObjectMap.put(command, r);
            super.execute(r);
        }

        @Override
        @NonNull
        public Future<?> submit(Runnable task) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(task, context);
            this.taskObjectMap.put(task, r);
            return super.submit(r);
        }

        @Override
        @NonNull
        public <T> Future<T> submit(Runnable task, T result) {
            Map context = MDC.getCopyOfContextMap();
            Runnable r = () -> this.run(task, context);
            this.taskObjectMap.put(task, r);
            return super.submit(r, result);
        }

        @Override
        @NonNull
        public <T> Future<T> submit(Callable<T> task) {
            Map context = MDC.getCopyOfContextMap();
            Callable<Object> c = () -> this.call(task, context);
            this.taskObjectMap.put(task, c);
            return super.submit(c);
        }

        @Override
        @NonNull
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAny(tasks.stream().map(task -> this.convert((Callable)task, context)).collect(Collectors.toList()));
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAny(tasks.stream().map(task -> this.convert((Callable)task, context)).collect(Collectors.toList()), timeout, unit);
        }

        @Override
        @NonNull
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAll(tasks.stream().map(task -> this.convert((Callable)task, context)).collect(Collectors.toList()));
        }

        @Override
        @NonNull
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            Map context = MDC.getCopyOfContextMap();
            return super.invokeAll(tasks.stream().map(task -> this.convert((Callable)task, context)).collect(Collectors.toList()), timeout, unit);
        }

        @Override
        public boolean remove(Runnable task) {
            try {
                boolean bl = super.remove((Runnable)this.taskObjectMap.get(task));
                return bl;
            }
            finally {
                this.taskObjectMap.remove(task);
            }
        }

        private void run(Runnable runnable, Map<String, String> context) {
            MDC.setContextMap(context);
            try {
                runnable.run();
            }
            finally {
                this.taskObjectMap.remove(runnable);
                MDC.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <V> V call(Callable<V> task, Map<String, String> context) throws Exception {
            MDC.setContextMap(context);
            try {
                V v = task.call();
                return v;
            }
            finally {
                this.taskObjectMap.remove(task);
                MDC.clear();
            }
        }

        private <V> Callable<V> convert(Callable<V> task, Map<String, String> context) {
            Callable<Object> t = () -> this.call(task, context);
            this.taskObjectMap.put(task, t);
            return t;
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolName + "-" + POOL_NUMBER.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

