/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.lang.NonNull;

public class ValidateCodeUtil {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};

    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String generateVerifyCode(@NonNull Integer verifySize) {
        return ValidateCodeUtil.generateVerifyCode(verifySize, false);
    }

    public static String generateNumberVerifyCode(@NonNull Integer verifySize) {
        return ValidateCodeUtil.generateVerifyCode(verifySize, true);
    }

    private static String generateVerifyCode(int verifySize, boolean isNumber) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int length = DIGITS.length;
        StringBuilder verifyCode = new StringBuilder(verifySize);
        for (int i = 0; i < verifySize; ++i) {
            if (isNumber) {
                verifyCode.append((char)DIGITS[((Random)rand).nextInt(10)]);
                continue;
            }
            verifyCode.append((char)DIGITS[Math.abs(((Random)rand).nextInt(length - 2) + 2)]);
        }
        return verifyCode.toString();
    }
}

