/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessor;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessorHolder;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.auth.validate.codes.slider.SliderCode;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.exception.ValidateCodeProcessException;
import top.dcenter.ums.security.core.util.IpUtil;
import top.dcenter.ums.security.core.util.MvcUtil;
import top.dcenter.ums.security.core.vo.ResponseResult;

@ResponseBody
public class ValidateCodeController
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(ValidateCodeController.class);
    private ValidateCodeProcessorHolder validateCodeProcessorHolder;
    @Autowired
    private ValidateCodeProperties validateCodeProperties;
    @Autowired
    private GenericApplicationContext applicationContext;

    @RequestMapping(value={"/code/{type}"})
    public void createCode(@PathVariable(value="type") String type, HttpServletRequest request, HttpServletResponse response) {
        ValidateCodeProcessor validateCodeProcessor = this.validateCodeProcessorHolder != null ? this.validateCodeProcessorHolder.findValidateCodeProcessor(type) : null;
        String ip = IpUtil.getRealIp(request);
        String errorMsg = ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE.getMsg();
        if (validateCodeProcessor == null) {
            log.warn("\u521b\u5efa\u9a8c\u8bc1\u7801\u9519\u8bef: error={}, ip={}, type={}", new Object[]{errorMsg, ip, type});
            throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, ip, type);
        }
        boolean validateStatus = validateCodeProcessor.produce(new ServletWebRequest(request, response));
        if (!validateStatus) {
            log.warn("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25: error={}, ip={}, type={}", new Object[]{errorMsg, ip, type});
            throw new ValidateCodeProcessException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, ip, type);
        }
    }

    @RequestMapping(value={"${ums.codes.slider.sliderCheckUrl}"}, method={RequestMethod.POST})
    public ResponseResult sliderCheck(HttpServletRequest request) {
        SliderCode sliderCode = (SliderCode)request.getSession().getAttribute(ValidateCodeType.SLIDER.getKeyPrefix());
        return ResponseResult.success(null, sliderCode.getCode());
    }

    public void afterPropertiesSet() throws Exception {
        this.validateCodeProcessorHolder = (ValidateCodeProcessorHolder)this.applicationContext.getBean(ValidateCodeProcessorHolder.class);
        String methodName = "sliderCheck";
        MvcUtil.setRequestMappingUri(methodName, this.validateCodeProperties.getSlider().getSliderCheckUrl(), this.getClass(), HttpServletRequest.class);
        methodName = "createCode";
        MvcUtil.setRequestMappingUri(methodName, this.validateCodeProperties.getValidateCodeUrlPrefix() + "/" + "{type}", this.getClass(), String.class, HttpServletRequest.class, HttpServletResponse.class);
        MvcUtil.registerController("validateCodeController", this.applicationContext, null);
    }
}

