/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.image;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.core.api.validate.code.image.ImageCodeFactory;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageCode;
import top.dcenter.ums.security.core.auth.validate.codes.image.ImageUtil;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

public class DefaultImageCodeFactory
implements ImageCodeFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultImageCodeFactory.class);
    public static final String IMAGE_NAME_DELIMITER = "_";
    private static final float PERCENTAGE = 0.9f;
    private final ValidateCodeProperties validateCodeProperties;
    private volatile String[] imageCodePaths = null;
    private final Integer totalImages;

    public DefaultImageCodeFactory(ValidateCodeProperties validateCodeProperties) {
        this.validateCodeProperties = validateCodeProperties;
        this.totalImages = validateCodeProperties.getTotalImages();
        this.readOrCreateCacheImageCodes();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImageCode getImageCode(ServletRequest request) {
        String imageCodePath;
        String imageFileName;
        ValidateCodeProperties.ImageCodeProperties imageProp = this.validateCodeProperties.getImage();
        int expireIn = imageProp.getExpire();
        Integer codeLength = imageProp.getLength();
        if (this.imageCodePaths != null && StringUtils.hasText((String)(imageFileName = ValidateCodeUtil.getFileName(imageCodePath = ValidateCodeUtil.getImageAbsPath(this.imageCodePaths))))) {
            String code = imageFileName.substring(0, codeLength);
            return new ImageCode(imageCodePath, code, expireIn);
        }
        int width = imageProp.getWidth();
        int height = imageProp.getHeight();
        String code = ValidateCodeUtil.generateVerifyCode(codeLength);
        String imageFileName2 = code + IMAGE_NAME_DELIMITER + ValidateCodeUtil.getUuid() + "." + "png";
        String imageAbsPath = ValidateCodeUtil.getAbsPath(imageProp.getImageCacheDirectory()) + "/" + imageFileName2;
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(imageAbsPath, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            ImageUtil.outputImage(width, height, outputStream, code);
            ImageCode imageCode = new ImageCode(imageAbsPath, code, expireIn);
            return imageCode;
        }
        catch (Exception e) {
            log.warn(String.format("\u751f\u6210\u9a8c\u8bc1\u7801\u56fe\u7247 %s \u5931\u8d25: %s", imageAbsPath, e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private void readOrCreateCacheImageCodes() {
        Instant now = Instant.now();
        String[] newImageCodePaths = new String[this.totalImages.intValue()];
        ValidateCodeProperties.ImageCodeProperties image = this.validateCodeProperties.getImage();
        String imageAbsPath = ValidateCodeUtil.getAbsPath(image.getImageCacheDirectory());
        File file = Paths.get(imageAbsPath, new String[0]).toFile();
        if (file.isDirectory() && file.canRead()) {
            List<File> fileList = Arrays.stream((Object[])Optional.ofNullable(file.listFiles()).orElse(new File[0])).filter(File::isFile).collect(Collectors.toList());
            int size = fileList.size();
            if (size >= (int)((float)this.totalImages.intValue() * 0.9f)) {
                ValidateCodeUtil.readFiles2CacheImageCodes(newImageCodePaths, fileList);
                this.imageCodePaths = newImageCodePaths;
            } else {
                fileList.forEach(f -> {
                    try {
                        Files.delete(f.toPath());
                    }
                    catch (IOException e) {
                        String msg = String.format("\u5220\u9664\u7f13\u5b58\u7684\u56fe\u7247\u9a8c\u8bc1\u7801 %s \u9519\u8bef: %s", f.getPath(), e.getMessage());
                        log.error(msg, (Throwable)e);
                    }
                });
                this.refreshValidateCodeJob();
            }
        }
        log.info("\u4ece\u7f13\u5b58\u4e2d\u8bfb\u53d6\u6216\u521b\u5efa\u56fe\u7247\u9a8c\u8bc1\u7801\u603b\u8017\u65f6: {} \u6beb\u79d2", (Object)(Instant.now().toEpochMilli() - now.toEpochMilli()));
    }

    @Override
    public void refreshValidateCodeJob() {
        Instant now = Instant.now();
        String[] oldImageCodePaths = this.imageCodePaths;
        String[] newImageCodePaths = new String[this.totalImages.intValue()];
        ValidateCodeProperties.ImageCodeProperties image = this.validateCodeProperties.getImage();
        Integer imageCodeLength = image.getLength();
        Integer height = image.getHeight();
        Integer width = image.getWidth();
        CopyOnWriteArrayList failures = new CopyOnWriteArrayList();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        int y = 0;
        while (y < this.totalImages) {
            String imageAbsPath;
            String code = ValidateCodeUtil.generateVerifyCode(imageCodeLength);
            String imageFileName = code + IMAGE_NAME_DELIMITER + ValidateCodeUtil.getUuid() + "." + "png";
            newImageCodePaths[y] = imageAbsPath = ValidateCodeUtil.getAbsPath(image.getImageCacheDirectory()) + "/" + imageFileName;
            int index = y++;
            CompletableFuture<Void> voidCompletableFuture = CompletableFuture.runAsync(() -> {
                try (OutputStream outputStream = Files.newOutputStream(Paths.get(imageAbsPath, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                    ImageUtil.outputImage((int)width, (int)height, outputStream, code);
                }
                catch (Exception e) {
                    failures.add(index + IMAGE_NAME_DELIMITER + imageAbsPath);
                }
            });
            futures.add(voidCompletableFuture);
        }
        try {
            ((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
                for (String failure : failures) {
                    String[] split = failure.split(IMAGE_NAME_DELIMITER, 2);
                    String imageAbsPath = split[1];
                    try {
                        OutputStream outputStream = Files.newOutputStream(Paths.get(imageAbsPath, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                        Throwable throwable = null;
                        try {
                            String fileName = imageAbsPath.substring(imageAbsPath.indexOf("/") + 1);
                            String code = fileName.substring(0, fileName.indexOf(IMAGE_NAME_DELIMITER));
                            ImageUtil.outputImage((int)width, (int)height, outputStream, code);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (outputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            outputStream.close();
                        }
                    }
                    catch (Exception e) {
                        newImageCodePaths[Integer.parseInt((String)split[0])] = ValidateCodeUtil.getImageAbsPath(newImageCodePaths);
                    }
                }
            })).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("\u521b\u5efa\u65b0\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25: " + e.getMessage(), (Throwable)e);
        }
        this.imageCodePaths = newImageCodePaths;
        if (oldImageCodePaths != null) {
            for (int i = 0; i < this.totalImages; ++i) {
                try {
                    boolean deleteIfExists = Files.deleteIfExists(Paths.get(oldImageCodePaths[i], new String[0]));
                    if (deleteIfExists) continue;
                    log.warn("\u5220\u9664\u65e7\u7684\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25: {}", (Object)oldImageCodePaths[i]);
                    continue;
                }
                catch (Exception e) {
                    log.warn("\u5220\u9664\u65e7\u7684\u9a8c\u8bc1\u7801\u56fe\u7247\u5931\u8d25: " + oldImageCodePaths[i], (Throwable)e);
                }
            }
            oldImageCodePaths = null;
        }
        log.info("\u751f\u6210\u56fe\u7247\u9a8c\u8bc1\u7801\u4efb\u52a1\u603b\u8017\u65f6={} \u6beb\u79d2", (Object)(Instant.now().toEpochMilli() - now.toEpochMilli()));
    }
}

