/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.mdc.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.mdc.config.MdcPropertiesAutoConfiguration;
import top.dcenter.ums.security.core.mdc.interceptor.MdcLogInterceptor;
import top.dcenter.ums.security.core.mdc.properties.MdcProperties;

@Configuration
@ConditionalOnProperty(prefix="ums.mdc", name={"enable"}, havingValue="true")
@AutoConfigureAfter(value={MdcPropertiesAutoConfiguration.class})
public class MdcLogWebMvcConfigurer
implements WebMvcConfigurer {
    private final MdcProperties mdcProperties;
    private final List<String> excludeUrls;

    public MdcLogWebMvcConfigurer(MdcProperties mdcProperties, ClientProperties clientProperties) {
        List<String> excludeUrls;
        this.mdcProperties = mdcProperties;
        this.excludeUrls = new ArrayList<String>();
        String[] ignoringUrls = clientProperties.getIgnoringUrls();
        if (null != ignoringUrls) {
            this.excludeUrls.addAll(Arrays.asList(ignoringUrls));
        }
        if (null != (excludeUrls = mdcProperties.getExcludeUrls())) {
            this.excludeUrls.addAll(excludeUrls);
        }
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(this.mdcLogInterceptor()).addPathPatterns(this.mdcProperties.getIncludeUrls()).excludePathPatterns(this.excludeUrls);
    }

    @Bean
    public HandlerInterceptor mdcLogInterceptor() {
        return new MdcLogInterceptor();
    }
}

