/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.repository.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import top.dcenter.ums.security.core.oauth.entity.AuthTokenPo;
import top.dcenter.ums.security.core.oauth.enums.EnableRefresh;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionTokenRepository;

@CacheConfig(cacheManager="auth2RedisHashCacheManager")
public class Auth2JdbcUsersConnectionTokenRepository
implements UsersConnectionTokenRepository {
    private final JdbcTemplate jdbcTemplate;
    private final TextEncryptor textEncryptor;
    private final AuthTokenPoMapper authTokenPoMapper = new AuthTokenPoMapper();

    public Auth2JdbcUsersConnectionTokenRepository(JdbcTemplate auth2UserConnectionJdbcTemplate, TextEncryptor textEncryptor) {
        this.jdbcTemplate = auth2UserConnectionJdbcTemplate;
        this.textEncryptor = textEncryptor;
    }

    @Override
    @Cacheable(cacheNames={"UCC"}, key="'s:token:' + #tokenId")
    public AuthTokenPo findAuthTokenById(String tokenId) throws DataAccessException {
        return (AuthTokenPo)((Object)this.jdbcTemplate.queryForObject("SELECT `id`, `enableRefresh`, `providerId`, `accessToken`, `expireIn`, `refreshToken`, `uid`, `openId`, `accessCode`, `unionId`, `scope`, `tokenType`, `idToken`, `macAlgorithm`, `macKey`, `code`, `oauthToken`, `oauthTokenSecret`, `userId`, `screenName`, `oauthCallbackConfirmed`, `expireTime` FROM auth_token WHERE id = ?;", (RowMapper)this.authTokenPoMapper, new Object[]{tokenId}));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    @CachePut(cacheNames={"UCC"}, key="'s:token:' + #result.id")
    public AuthTokenPo saveAuthToken(AuthTokenPo authToken) throws DataAccessException {
        this.jdbcTemplate.update("INSERT INTO auth_token(`enableRefresh` ,`providerId`, `accessToken`, `expireIn`, `refreshToken`, `uid`, `openId`, `accessCode`, `unionId`, `scope`, `tokenType`, `idToken`, `macAlgorithm`, `macKey`, `code`, `oauthToken`, `oauthTokenSecret`, `userId`, `screenName`, `oauthCallbackConfirmed`, `expireTime`) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);", new Object[]{authToken.getEnableRefresh().getCode(), authToken.getProviderId(), this.encrypt(authToken.getAccessToken()), authToken.getExpireIn(), this.encrypt(authToken.getRefreshToken()), authToken.getUid(), authToken.getOpenId(), this.encrypt(authToken.getAccessCode()), authToken.getUnionId(), authToken.getScope(), authToken.getTokenType(), this.encrypt(authToken.getIdToken()), authToken.getMacAlgorithm(), this.encrypt(authToken.getMacKey()), this.encrypt(authToken.getCode()), this.encrypt(authToken.getOauthToken()), this.encrypt(authToken.getOauthTokenSecret()), authToken.getUserId(), authToken.getScreenName(), authToken.getOauthCallbackConfirmed(), authToken.getExpireTime()});
        Long id = (Long)this.jdbcTemplate.queryForObject("SELECT LAST_INSERT_ID();", null, Long.class);
        authToken.setId(id);
        return authToken;
    }

    @Override
    @CachePut(cacheNames={"UCC"}, key="'s:token:' + #result.id")
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public AuthTokenPo updateAuthToken(@NonNull AuthTokenPo authToken) throws DataAccessException {
        if (authToken.getId() == null) {
            throw new RuntimeException("authToken id cannot be null");
        }
        this.jdbcTemplate.update("UPDATE `auth_token` SET `enableRefresh` = ?, `providerId` = ?, `accessToken` = ?, `expireIn` = ?, `refreshToken` = ?, `uid` = ?, `openId` = ?, `accessCode` = ?, `unionId` = ?, `scope` = ?, `tokenType` = ?, `idToken` = ?, `macAlgorithm` = ?, `macKey` = ?, `code` = ?, `oauthToken` = ?, `oauthTokenSecret` = ?, `userId` = ?, `screenName` = ?, `oauthCallbackConfirmed` = ?, `expireTime` = ? WHERE `id` = ?;", new Object[]{authToken.getEnableRefresh().getCode(), authToken.getProviderId(), this.encrypt(authToken.getAccessToken()), authToken.getExpireIn(), this.encrypt(authToken.getRefreshToken()), authToken.getUid(), authToken.getOpenId(), this.encrypt(authToken.getAccessCode()), authToken.getUnionId(), authToken.getScope(), authToken.getTokenType(), this.encrypt(authToken.getIdToken()), authToken.getMacAlgorithm(), this.encrypt(authToken.getMacKey()), this.encrypt(authToken.getCode()), this.encrypt(authToken.getOauthToken()), this.encrypt(authToken.getOauthTokenSecret()), authToken.getUserId(), authToken.getScreenName(), authToken.getOauthCallbackConfirmed(), authToken.getExpireTime(), authToken.getId()});
        return authToken;
    }

    @Override
    @CacheEvict(cacheNames={"UCC"}, key="'s:token:' + #tokenId", beforeInvocation=true)
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void delAuthTokenById(@NonNull String tokenId) throws DataAccessException {
        this.jdbcTemplate.update("DELETE FROM auth_token WHERE id = ?;", new Object[]{tokenId});
    }

    @Override
    public Long getMaxTokenId() throws IncorrectResultSizeDataAccessException {
        return (Long)this.jdbcTemplate.queryForObject("SELECT MAX(`id`) FROM `auth_token`", Long.class);
    }

    @Override
    public List<AuthTokenPo> findAuthTokenByExpireTimeAndBetweenId(@NonNull Long expiredTime, @NonNull Long startId, @NonNull Long endId) throws DataAccessException {
        return this.jdbcTemplate.query("SELECT `id`, `enableRefresh`, `providerId`, `accessToken`, `expireIn`, `refreshToken`, `uid`, `openId`, `accessCode`, `unionId`, `scope`, `tokenType`, `idToken`, `macAlgorithm`, `macKey`, `code`, `oauthToken`, `oauthTokenSecret`, `userId`, `screenName`, `oauthCallbackConfirmed`, `expireTime` FROM auth_token WHERE id BETWEEN ? AND ? AND `expireTime` <= ? AND enableRefresh = " + EnableRefresh.YES.getCode() + ";", (RowMapper)this.authTokenPoMapper, new Object[]{startId, endId, expiredTime});
    }

    @Override
    @CacheEvict(cacheNames={"UCC"}, key="'s:token:' + #tokenId", beforeInvocation=true)
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void updateEnableRefreshByTokenId(@NonNull EnableRefresh enableRefresh, @NonNull Long tokenId) throws DataAccessException {
        this.jdbcTemplate.update("update `auth_token` set `enableRefresh` = ? where id = ?", new Object[]{enableRefresh.getCode(), tokenId});
    }

    private String encrypt(String text) {
        return text != null ? this.textEncryptor.encrypt(text) : null;
    }

    private final class AuthTokenPoMapper
    implements RowMapper<AuthTokenPo> {
        private AuthTokenPoMapper() {
        }

        public AuthTokenPo mapRow(@NonNull ResultSet rs, int rowNum) throws SQLException {
            return this.mapAuthToken(rs);
        }

        private AuthTokenPo mapAuthToken(ResultSet rs) throws SQLException {
            AuthTokenPo token = new AuthTokenPo();
            token.setId(rs.getLong("id"));
            int enableRefresh = rs.getInt("enableRefresh");
            token.setEnableRefresh(enableRefresh == EnableRefresh.YES.getCode() ? EnableRefresh.YES : EnableRefresh.NO);
            token.setProviderId(rs.getString("providerId"));
            token.setAccessToken(this.decrypt(rs.getString("accessToken")));
            token.setExpireIn(rs.getInt("expireIn"));
            token.setRefreshToken(this.decrypt(rs.getString("refreshToken")));
            token.setUid(rs.getString("uid"));
            token.setOpenId(rs.getString("openId"));
            token.setAccessCode(this.decrypt(rs.getString("accessCode")));
            token.setUnionId(rs.getString("unionId"));
            token.setScope(rs.getString("scope"));
            token.setTokenType(rs.getString("tokenType"));
            token.setIdToken(this.decrypt(rs.getString("idToken")));
            token.setMacAlgorithm(rs.getString("macAlgorithm"));
            token.setMacKey(this.decrypt(rs.getString("macKey")));
            token.setCode(this.decrypt(rs.getString("code")));
            token.setOauthToken(this.decrypt(rs.getString("oauthToken")));
            token.setOauthTokenSecret(this.decrypt(rs.getString("oauthTokenSecret")));
            token.setUserId(rs.getString("userId"));
            token.setScreenName(rs.getString("screenName"));
            token.setOauthCallbackConfirmed(rs.getBoolean("oauthCallbackConfirmed"));
            token.setExpireTime(rs.getLong("expireTime"));
            return token;
        }

        private String decrypt(String encryptedText) {
            return encryptedText != null ? Auth2JdbcUsersConnectionTokenRepository.this.textEncryptor.decrypt(encryptedText) : null;
        }

        private Long expireTime(long expireTime) {
            return expireTime == 0L ? null : Long.valueOf(expireTime);
        }
    }
}

