/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.signup;

import java.util.List;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.oauth.state.service.Auth2StateCoder;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.exception.RegisterUserFailureException;
import top.dcenter.ums.security.core.oauth.entity.AuthTokenPo;
import top.dcenter.ums.security.core.oauth.entity.ConnectionData;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.oauth.justauth.util.JustAuthUtil;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionRepository;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionTokenRepository;
import top.dcenter.ums.security.core.oauth.repository.exception.UpdateConnectionException;
import top.dcenter.ums.security.core.oauth.signup.ConnectionService;
import top.dcenter.ums.security.core.util.MvcUtil;

public class DefaultConnectionServiceImpl
implements ConnectionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultConnectionServiceImpl.class);
    private final Integer timeout;
    private final UmsUserDetailsService userDetailsService;
    private final String defaultAuthorities;
    private final UsersConnectionRepository usersConnectionRepository;
    private final UsersConnectionTokenRepository usersConnectionTokenRepository;
    private final Auth2StateCoder auth2StateCoder;

    public DefaultConnectionServiceImpl(UmsUserDetailsService userDetailsService, Auth2Properties auth2Properties, UsersConnectionRepository usersConnectionRepository, UsersConnectionTokenRepository usersConnectionTokenRepository, Auth2StateCoder auth2StateCoder) {
        this.userDetailsService = userDetailsService;
        this.defaultAuthorities = auth2Properties.getDefaultAuthorities();
        this.usersConnectionRepository = usersConnectionRepository;
        this.usersConnectionTokenRepository = usersConnectionTokenRepository;
        this.timeout = auth2Properties.getProxy().getHttpConfig().getTimeout();
        this.auth2StateCoder = auth2StateCoder;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public UserDetails signUp(@NonNull AuthUser authUser, @NonNull String providerId, @NonNull String encodeState) throws RegisterUserFailureException {
        String username = authUser.getUsername();
        String[] usernames = this.userDetailsService.generateUsernames(authUser);
        try {
            username = null;
            List<Boolean> existedByUserIds = this.userDetailsService.existedByUsernames(usernames);
            int len = existedByUserIds.size();
            for (int i = 0; i < len; ++i) {
                if (existedByUserIds.get(i).booleanValue()) continue;
                username = usernames[i];
                break;
            }
            if (username == null) {
                throw new RegisterUserFailureException(ErrorCodeEnum.USERNAME_USED, authUser.getUsername());
            }
            String decodeState = this.auth2StateCoder != null ? this.auth2StateCoder.decode(encodeState) : encodeState;
            UserDetails userDetails = this.userDetailsService.registerUser(authUser, username, this.defaultAuthorities, decodeState);
            this.registerConnection(providerId, authUser, userDetails);
            return userDetails;
        }
        catch (Exception e) {
            log.error(String.format("OAuth2\u81ea\u52a8\u6ce8\u518c\u5931\u8d25: error=%s, username=%s, authUser=%s", e.getMessage(), username, MvcUtil.toJsonString(authUser)), (Throwable)e);
            throw new RegisterUserFailureException(ErrorCodeEnum.USER_REGISTER_FAILURE, username);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void updateUserConnection(AuthUser authUser, ConnectionData data) throws UpdateConnectionException {
        ConnectionData connectionData = null;
        try {
            AuthToken token = authUser.getToken();
            AuthTokenPo authToken = JustAuthUtil.getAuthTokenPo(token, data.getProviderId(), this.timeout);
            authToken.setId(data.getTokenId());
            Auth2DefaultRequest.expireIn2Timestamp(this.timeout, token.getExpireIn(), authToken);
            connectionData = JustAuthUtil.getConnectionData(data.getProviderId(), authUser, data.getUserId(), authToken);
            connectionData.setUserId(data.getUserId());
            connectionData.setTokenId(data.getTokenId());
            this.usersConnectionRepository.updateConnection(connectionData);
            this.usersConnectionTokenRepository.updateAuthToken(authToken);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new UpdateConnectionException(ErrorCodeEnum.UPDATE_CONNECTION_DATA_FAILURE, connectionData, e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void binding(UserDetails principal, AuthUser authUser, String providerId) {
        this.registerConnection(providerId, authUser, principal);
    }

    private void registerConnection(String providerId, AuthUser authUser, UserDetails userDetails) throws RegisterUserFailureException {
        AuthToken token = authUser.getToken();
        AuthTokenPo authToken = JustAuthUtil.getAuthTokenPo(token, providerId, this.timeout);
        Auth2DefaultRequest.expireIn2Timestamp(this.timeout, token.getExpireIn(), authToken);
        try {
            this.usersConnectionTokenRepository.saveAuthToken(authToken);
            this.addConnectionData(providerId, authUser, userDetails.getUsername(), authToken);
        }
        catch (Exception e) {
            if (authToken.getId() == null) {
                try {
                    this.usersConnectionTokenRepository.saveAuthToken(authToken);
                    this.addConnectionData(providerId, authUser, userDetails.getUsername(), authToken);
                }
                catch (Exception ex) {
                    String msg = String.format("\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u81ea\u52a8\u6ce8\u518c\u65f6: \u672c\u5730\u8d26\u6237\u6ce8\u518c\u6210\u529f, %s, \u6dfb\u52a0\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u4fe1\u606f\u5931\u8d25: %s", userDetails, MvcUtil.toJsonString(authUser));
                    log.error(msg, (Throwable)e);
                    throw new RegisterUserFailureException(ErrorCodeEnum.USER_REGISTER_OAUTH2_FAILURE, ex, userDetails.getUsername());
                }
            }
            try {
                this.addConnectionData(providerId, authUser, userDetails.getUsername(), authToken);
            }
            catch (Exception exception) {
                String msg = String.format("\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u81ea\u52a8\u6ce8\u518c\u65f6: \u672c\u5730\u8d26\u6237\u6ce8\u518c\u6210\u529f, %s, \u6dfb\u52a0\u7b2c\u4e09\u65b9\u6388\u6743\u767b\u5f55\u4fe1\u606f\u5931\u8d25: %s, \u4f46 AuthToken \u80fd\u6210\u529f\u6267\u884c sql, \u4f46\u5df2\u56de\u6eda: %s", userDetails, authUser.getRawUserInfo(), MvcUtil.toJsonString((Object)authToken));
                log.error(msg, (Throwable)e);
                throw new RegisterUserFailureException(ErrorCodeEnum.USER_REGISTER_OAUTH2_FAILURE, userDetails.getUsername());
            }
        }
    }

    private void addConnectionData(String providerId, AuthUser authUser, String userId, AuthTokenPo authToken) {
        ConnectionData connectionData = JustAuthUtil.getConnectionData(providerId, authUser, userId, authToken);
        this.usersConnectionRepository.addConnection(connectionData);
    }
}

