/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.interceptor;

import java.time.Instant;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import top.dcenter.ums.security.core.api.permission.service.UriAuthorizeService;
import top.dcenter.ums.security.core.permission.annotation.UriAuthorize;
import top.dcenter.ums.security.core.util.IpUtil;

public class UriAuthorizationAnnotationInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(UriAuthorizationAnnotationInterceptor.class);
    private final UriAuthorizeService uriAuthorizeService;

    public UriAuthorizationAnnotationInterceptor(UriAuthorizeService uriAuthorizeService) {
        this.uriAuthorizeService = uriAuthorizeService;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        UriAuthorize methodAnnotation = (UriAuthorize)((HandlerMethod)handler).getMethodAnnotation(UriAuthorize.class);
        if (methodAnnotation == null) {
            return true;
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        boolean hasPermission = this.uriAuthorizeService.hasPermission(request, authentication, methodAnnotation.value());
        String sid = request.getSession(true).getId();
        Object principal = authentication.getPrincipal();
        String ip = IpUtil.getRealIp(request);
        String uri = request.getRequestURI();
        long now = Instant.now().toEpochMilli();
        String referer = request.getHeader("referer");
        String userAgent = request.getHeader("User-Agent");
        String method = request.getMethod();
        if (hasPermission) {
            log.info("URI\u6743\u9650\u63a7\u5236-\u653e\u884c: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, uri, method, now, referer, userAgent});
            return true;
        }
        log.warn("URI\u6743\u9650\u63a7\u5236-\u7981\u6b62: sid={}, user={}, ip={}, uri={}, method={}, time={}, referer={}, agent={}", new Object[]{sid, principal, ip, uri, method, now, referer, userAgent});
        this.uriAuthorizeService.handlerError(HttpStatus.FORBIDDEN.value(), response);
        return false;
    }
}

