/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.enums.LoginProcessType;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.util.MvcUtil;
import top.dcenter.ums.security.core.vo.ResponseResult;

public class AuthenticationUtil {
    public static final String EXTRACT_USER_AGENT_REGEX = "[\\.\\d\\s\\(\\)]";

    public static void registerHandlerAndRememberMeServices(AbstractAuthenticationProcessingFilter abstractAuthenticationProcessingFilter, BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, PersistentTokenRepository persistentTokenRepository, UmsUserDetailsService userDetailsService, ClientProperties clientProperties) {
        if (baseAuthenticationFailureHandler != null) {
            abstractAuthenticationProcessingFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)baseAuthenticationFailureHandler);
        }
        if (baseAuthenticationSuccessHandler != null) {
            abstractAuthenticationProcessingFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)baseAuthenticationSuccessHandler);
        }
        if (persistentTokenRepository != null) {
            PersistentTokenBasedRememberMeServices persistentTokenBasedRememberMeServices = new PersistentTokenBasedRememberMeServices(UUID.randomUUID().toString(), (UserDetailsService)userDetailsService, persistentTokenRepository);
            ClientProperties.RememberMeProperties rememberMe = clientProperties.getRememberMe();
            persistentTokenBasedRememberMeServices.setTokenValiditySeconds(Integer.parseInt(String.valueOf(rememberMe.getRememberMeTimeout().getSeconds())));
            persistentTokenBasedRememberMeServices.setParameter(rememberMe.getRememberMeCookieName());
            abstractAuthenticationProcessingFilter.setRememberMeServices((RememberMeServices)persistentTokenBasedRememberMeServices);
        }
    }

    public static AbstractResponseJsonAuthenticationException getAbstractResponseJsonAuthenticationException(AuthenticationException exception) {
        AbstractResponseJsonAuthenticationException e = null;
        if (exception instanceof AbstractResponseJsonAuthenticationException) {
            e = (AbstractResponseJsonAuthenticationException)exception;
        }
        return e;
    }

    public static boolean isPermitUri(@NonNull HttpServletRequest request, @NonNull HttpSession session, @NonNull AntPathMatcher matcher) {
        String requestUri = MvcUtil.getUrlPathHelper().getPathWithinApplication(request);
        String method = request.getMethod();
        return AuthenticationUtil.isPermitUri(requestUri, method, session, matcher);
    }

    private static boolean isPermitUri(@NonNull String requestUri, @NonNull String method, @NonNull HttpSession session, @NonNull AntPathMatcher matcher) {
        Set permitAllSet = (Set)session.getServletContext().getAttribute("SERVLET_CONTEXT_PERMIT_ALL_SET_KEY");
        permitAllSet = Optional.ofNullable(permitAllSet).orElse(new HashSet(0));
        for (UriHttpMethodTuple tuple : permitAllSet) {
            if (!matcher.match(tuple.getUri(), requestUri)) continue;
            HttpMethod httpMethod = tuple.getMethod();
            if (httpMethod == null) {
                return true;
            }
            String name = httpMethod.name();
            if (!name.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean authenticationFailureProcessing(HttpServletResponse response, AuthenticationException exception, AbstractResponseJsonAuthenticationException e, String acceptHeader, ClientProperties clientProperties) throws IOException {
        boolean isAcceptHeader;
        boolean isJsonProcessType = LoginProcessType.JSON.equals((Object)clientProperties.getLoginProcessType());
        boolean bl = isAcceptHeader = StringUtils.hasText((String)acceptHeader) && (acceptHeader.contains("application/x-www-form-urlencoded") || acceptHeader.contains("application/json"));
        if (isJsonProcessType || isAcceptHeader) {
            int status = HttpStatus.UNAUTHORIZED.value();
            ResponseResult result = e != null ? ResponseResult.fail(e.getErrorCodeEnum(), e.getData()) : ResponseResult.fail(exception.getMessage(), ErrorCodeEnum.UNAUTHORIZED);
            AuthenticationUtil.responseWithJson(response, status, MvcUtil.toJsonString(result));
            return true;
        }
        return false;
    }

    public static void responseWithJson(HttpServletResponse response, int status, String result) throws IOException {
        response.setStatus(status);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter writer = response.getWriter();
        writer.write(result);
        writer.flush();
    }

    public static String extractUserAgent(String userAgent) {
        return userAgent.replaceAll(EXTRACT_USER_AGENT_REGEX, "");
    }

    public static void redirectProcessingLogoutByLoginProcessType(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum) throws IOException {
        AuthenticationUtil.redirectProcessing(request, response, clientProperties, redirectStrategy, errorCodeEnum, clientProperties.getLogoutSuccessUrl());
    }

    public static void redirectProcessingByLoginProcessType(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum, String redirectUrl) throws IOException {
        String referer = Optional.ofNullable(request.getHeader("Referer")).orElse(redirectUrl);
        AuthenticationUtil.redirectProcessing(request, response, clientProperties, redirectStrategy, errorCodeEnum, referer);
    }

    public static String determineInvalidSessionRedirectUrl(HttpServletRequest request, HttpServletResponse response, String destinationUrl, AntPathMatcher matcher, RequestCache requestCache) {
        HttpSession session = request.getSession();
        String redirectUrl = destinationUrl;
        String originalUrl = null;
        if (AuthenticationUtil.isPermitUri(request, session, matcher)) {
            redirectUrl = request.getRequestURL().toString() + Optional.ofNullable(request.getQueryString()).orElse("");
        } else {
            SavedRequest savedRequest = requestCache.getRequest(request, response);
            originalUrl = request.getRequestURL().toString() + Optional.ofNullable(request.getQueryString()).orElse("");
            if (savedRequest != null) {
                originalUrl = Optional.ofNullable(savedRequest.getRedirectUrl()).orElse(originalUrl);
            }
        }
        session = request.getSession();
        session.removeAttribute("SESSION_ENHANCE_CHECK_KEY");
        if (originalUrl != null) {
            session.setAttribute("SESSION_REDIRECT_URL_KEY", (Object)originalUrl);
        }
        return redirectUrl;
    }

    public static String getOriginalUrl(RequestCache requestCache, HttpServletRequest request, HttpServletResponse response, String defaultRedirectUrl) throws IOException {
        HttpSession session;
        String originalUrl;
        SavedRequest savedRequest = requestCache.getRequest(request, response);
        String redirectUrl = defaultRedirectUrl;
        if (savedRequest != null) {
            redirectUrl = Optional.ofNullable(savedRequest.getRedirectUrl()).orElse(redirectUrl);
        }
        if (StringUtils.hasText((String)(originalUrl = (String)(session = request.getSession()).getAttribute("SESSION_REDIRECT_URL_KEY")))) {
            redirectUrl = originalUrl;
            session.removeAttribute("SESSION_REDIRECT_URL_KEY");
        }
        return redirectUrl;
    }

    private static void redirectProcessing(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum, String redirectUrl) throws IOException {
        if (LoginProcessType.JSON.equals((Object)clientProperties.getLoginProcessType())) {
            int status = HttpStatus.UNAUTHORIZED.value();
            response.setStatus(status);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(MvcUtil.toJsonString(ResponseResult.fail(errorCodeEnum, redirectUrl)));
            return;
        }
        redirectStrategy.sendRedirect(request, response, redirectUrl);
    }
}

