/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code;

import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.validate.code.ValidateCode;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGenerator;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessor;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeCacheType;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.util.IpUtil;

public abstract class AbstractValidateCodeProcessor
implements ValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractValidateCodeProcessor.class);
    protected final ValidateCodeGeneratorHolder validateCodeGeneratorHolder;
    protected final StringRedisTemplate stringRedisTemplate;
    protected final ValidateCodeCacheType validateCodeCacheType;
    protected final Class<? extends ValidateCode> validateCodeClass;

    public AbstractValidateCodeProcessor(@NonNull ValidateCodeGeneratorHolder validateCodeGeneratorHolder, @NonNull ValidateCodeCacheType validateCodeCacheType, @NonNull Class<? extends ValidateCode> validateCodeClass, @Nullable StringRedisTemplate stringRedisTemplate) {
        this.validateCodeGeneratorHolder = validateCodeGeneratorHolder;
        this.validateCodeCacheType = validateCodeCacheType;
        this.validateCodeClass = validateCodeClass;
        this.stringRedisTemplate = stringRedisTemplate;
        if (ValidateCodeCacheType.REDIS.equals((Object)validateCodeCacheType)) {
            Objects.requireNonNull(stringRedisTemplate, "stringRedisTemplate cannot be null");
        }
    }

    @Override
    public final boolean produce(ServletWebRequest request) throws ValidateCodeException {
        HttpServletRequest req = request.getRequest();
        String ip = IpUtil.getRealIp(req);
        String sid = request.getSessionId();
        String uri = req.getRequestURI();
        try {
            ValidateCode validateCode = this.generate(request);
            boolean validateStatus = this.sent(request, validateCode);
            if (!validateStatus) {
                log.warn("\u53d1\u9001\u9a8c\u8bc1\u7801\u5931\u8d25: ip={}, sid={}, uri={}, validateCode={}", new Object[]{ip, sid, uri, validateCode.toString()});
                return false;
            }
            this.save(request, validateCode);
        }
        catch (Exception e) {
            this.validateCodeCacheType.removeCache(request, this.getValidateCodeType(), this.stringRedisTemplate);
            if (e instanceof ValidateCodeException) {
                ValidateCodeException exception = (ValidateCodeException)((Object)e);
                String msg = String.format("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25: error=%s, ip=%s, uid=%s, sid=%s, uri=%s, data=%s", exception.getMessage(), ip, exception.getUid(), sid, uri, exception.getData());
                log.warn(msg, (Throwable)((Object)exception));
                throw exception;
            }
            String msg = String.format("\u751f\u6210\u9a8c\u8bc1\u7801\u5931\u8d25: error=%s, ip=%s, sid=%s, uri=%s", e.getMessage(), ip, sid, uri);
            log.warn(msg, (Throwable)e);
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, (Throwable)e, ip, uri);
        }
        return true;
    }

    @Override
    public final ValidateCode generate(ServletWebRequest request) {
        try {
            ValidateCodeGenerator<?> validateCodeGenerator = this.getValidateCodeGenerator(this.getValidateCodeType());
            ValidateCode validateCode = (ValidateCode)validateCodeGenerator.generate((ServletRequest)request.getRequest());
            if (validateCode == null) {
                throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, IpUtil.getRealIp(request.getRequest()), request.getRequest().getRequestURI());
            }
            return validateCode;
        }
        catch (ValidateCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, (Throwable)e, IpUtil.getRealIp(request.getRequest()), request.getRequest().getRequestURI());
        }
    }

    @Override
    public boolean save(ServletWebRequest request, ValidateCode validateCode) {
        ValidateCodeType validateCodeType = this.getValidateCodeType();
        try {
            return this.validateCodeCacheType.save(request, validateCode, validateCodeType, this.stringRedisTemplate);
        }
        catch (Exception e) {
            String msg = String.format("\u9a8c\u8bc1\u7801\u4fdd\u5b58\u5230Session\u5931\u8d25: error=%s, ip=%s, code=%s", e.getMessage(), IpUtil.getRealIp(request.getRequest()), validateCode);
            log.error(msg, (Throwable)e);
            return false;
        }
    }

    @Override
    public abstract boolean sent(ServletWebRequest var1, ValidateCode var2);

    @Override
    public void validate(ServletWebRequest request) throws ValidateCodeException {
        ValidateCodeType validateCodeType = this.getValidateCodeType();
        ValidateCodeGenerator<?> validateCodeGenerator = this.getValidateCodeGenerator(validateCodeType);
        this.defaultValidate(request, validateCodeGenerator.getRequestParamValidateCodeName(), this.validateCodeClass, this.validateCodeCacheType, this.stringRedisTemplate);
    }

    @Override
    public abstract ValidateCodeType getValidateCodeType();

    protected ValidateCodeGenerator<?> getValidateCodeGenerator(ValidateCodeType type) throws ValidateCodeException {
        try {
            ValidateCodeGenerator<?> validateCodeGenerator = this.validateCodeGeneratorHolder.findValidateCodeGenerator(type);
            if (validateCodeGenerator != null) {
                return validateCodeGenerator;
            }
            throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, null, type.name());
        }
        catch (Exception e) {
            throw new ValidateCodeException(ErrorCodeEnum.ILLEGAL_VALIDATE_CODE_TYPE, (Throwable)e, null, type.name());
        }
    }
}

