/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code.enums;

import java.lang.reflect.Field;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.validate.code.ValidateCode;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.util.IpUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public enum ValidateCodeCacheType {
    SESSION{

        @Override
        public boolean save(@NonNull ServletWebRequest request, @NonNull ValidateCode validateCode, @NonNull ValidateCodeType validateCodeType, @Nullable StringRedisTemplate stringRedisTemplate) {
            HttpServletRequest req = request.getRequest();
            try {
                ValidateCodeCacheType.removeUnnecessaryFieldValue(validateCode);
                req.getSession().setAttribute(validateCodeType.getKeyPrefix(), (Object)validateCode);
            }
            catch (Exception e) {
                String msg = String.format("\u9a8c\u8bc1\u7801\u4fdd\u5b58\u5230 Session \u5931\u8d25: error=%s, ip=%s, code=%s", e.getMessage(), IpUtil.getRealIp(req), validateCode);
                log.error(msg, (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public ValidateCode getCodeInCache(@NonNull ServletWebRequest request, @NonNull ValidateCodeType validateCodeType, @NonNull Class<? extends ValidateCode> clz, @Nullable StringRedisTemplate stringRedisTemplate) {
            return clz.cast(request.getRequest().getSession().getAttribute(validateCodeType.getKeyPrefix()));
        }

        @Override
        public void removeCache(@NonNull ServletWebRequest request, @NonNull ValidateCodeType validateCodeType, @Nullable StringRedisTemplate stringRedisTemplate) {
            request.getRequest().getSession().removeAttribute(validateCodeType.getKeyPrefix());
        }
    }
    ,
    REDIS{

        @Override
        public boolean save(@NonNull ServletWebRequest request, @NonNull ValidateCode validateCode, @NonNull ValidateCodeType validateCodeType, StringRedisTemplate stringRedisTemplate) {
            Objects.requireNonNull(stringRedisTemplate, "stringRedisTemplate cannot be null");
            try {
                ValidateCodeCacheType.removeUnnecessaryFieldValue(validateCode);
                stringRedisTemplate.opsForValue().set((Object)(validateCodeType.getKeyPrefix() + request.getSessionId()), (Object)MvcUtil.toJsonString(validateCode), (long)validateCodeType.getExpireIn().intValue(), TimeUnit.SECONDS);
            }
            catch (Exception e) {
                String msg = String.format("\u9a8c\u8bc1\u7801\u4fdd\u5b58\u5230 redis \u5931\u8d25: error=%s, ip=%s, code=%s", e.getMessage(), IpUtil.getRealIp(request.getRequest()), validateCode);
                log.error(msg, (Throwable)e);
                return false;
            }
            return true;
        }

        @Override
        public ValidateCode getCodeInCache(@NonNull ServletWebRequest request, @NonNull ValidateCodeType validateCodeType, @NonNull Class<? extends ValidateCode> clz, StringRedisTemplate stringRedisTemplate) {
            String json = (String)stringRedisTemplate.opsForValue().get((Object)(validateCodeType.getKeyPrefix() + request.getSessionId()));
            if (!StringUtils.hasText((String)json)) {
                return null;
            }
            return MvcUtil.json2Object(json, clz);
        }

        @Override
        public void removeCache(@NonNull ServletWebRequest request, @NonNull ValidateCodeType validateCodeType, StringRedisTemplate stringRedisTemplate) {
            stringRedisTemplate.delete((Object)(validateCodeType.getKeyPrefix() + request.getSessionId()));
        }
    };

    private static final Logger log;

    public abstract boolean save(@NonNull ServletWebRequest var1, @NonNull ValidateCode var2, @NonNull ValidateCodeType var3, @Nullable StringRedisTemplate var4);

    public abstract ValidateCode getCodeInCache(@NonNull ServletWebRequest var1, @NonNull ValidateCodeType var2, @NonNull Class<? extends ValidateCode> var3, @Nullable StringRedisTemplate var4);

    public abstract void removeCache(@NonNull ServletWebRequest var1, @NonNull ValidateCodeType var2, @Nullable StringRedisTemplate var3);

    private static void removeUnnecessaryFieldValue(ValidateCode validateCode) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = validateCode.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Transient aTransient = field.getDeclaredAnnotation(Transient.class);
            if (aTransient == null) continue;
            field.set(validateCode, null);
        }
    }

    static {
        log = LoggerFactory.getLogger(ValidateCodeCacheType.class);
    }
}

