/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.properties;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import top.dcenter.ums.security.core.oauth.enums.RejectedExecutionHandlerPolicy;

@ConfigurationProperties(value="ums.executor")
public class ExecutorProperties {
    private final JobTaskScheduledExecutorProperties jobTaskScheduledExecutor = new JobTaskScheduledExecutorProperties();
    private final RefreshTokenExecutorProperties refreshToken = new RefreshTokenExecutorProperties();
    private final UserConnectionUpdateExecutorProperties userConnectionUpdate = new UserConnectionUpdateExecutorProperties();

    public JobTaskScheduledExecutorProperties getJobTaskScheduledExecutor() {
        return this.jobTaskScheduledExecutor;
    }

    public RefreshTokenExecutorProperties getRefreshToken() {
        return this.refreshToken;
    }

    public UserConnectionUpdateExecutorProperties getUserConnectionUpdate() {
        return this.userConnectionUpdate;
    }

    public static class UserConnectionUpdateExecutorProperties {
        private Integer corePoolSize = 1;
        private Integer maximumPoolSize = Runtime.getRuntime().availableProcessors();
        private Integer keepAliveTime = 10;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private Integer blockingQueueCapacity = this.maximumPoolSize * 2;
        private String poolName = "updateConnection";
        private RejectedExecutionHandlerPolicy rejectedExecutionHandlerPolicy = RejectedExecutionHandlerPolicy.CALLER_RUNS;
        private Duration executorShutdownTimeout = Duration.ofSeconds(10L);

        public Integer getCorePoolSize() {
            return this.corePoolSize;
        }

        public Integer getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public Integer getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public Integer getBlockingQueueCapacity() {
            return this.blockingQueueCapacity;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public RejectedExecutionHandlerPolicy getRejectedExecutionHandlerPolicy() {
            return this.rejectedExecutionHandlerPolicy;
        }

        public Duration getExecutorShutdownTimeout() {
            return this.executorShutdownTimeout;
        }

        public void setCorePoolSize(Integer corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaximumPoolSize(Integer maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public void setKeepAliveTime(Integer keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public void setBlockingQueueCapacity(Integer blockingQueueCapacity) {
            this.blockingQueueCapacity = blockingQueueCapacity;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public void setRejectedExecutionHandlerPolicy(RejectedExecutionHandlerPolicy rejectedExecutionHandlerPolicy) {
            this.rejectedExecutionHandlerPolicy = rejectedExecutionHandlerPolicy;
        }

        public void setExecutorShutdownTimeout(Duration executorShutdownTimeout) {
            this.executorShutdownTimeout = executorShutdownTimeout;
        }
    }

    public static class RefreshTokenExecutorProperties {
        private Integer corePoolSize = 0;
        private Integer maximumPoolSize = Runtime.getRuntime().availableProcessors();
        private Integer keepAliveTime = 5;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private Integer blockingQueueCapacity = this.maximumPoolSize * 2;
        private String poolName = "refreshToken";
        private RejectedExecutionHandlerPolicy rejectedExecutionHandlerPolicy = RejectedExecutionHandlerPolicy.CALLER_RUNS;
        private Duration executorShutdownTimeout = Duration.ofSeconds(10L);

        public Integer getCorePoolSize() {
            return this.corePoolSize;
        }

        public Integer getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public Integer getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public Integer getBlockingQueueCapacity() {
            return this.blockingQueueCapacity;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public RejectedExecutionHandlerPolicy getRejectedExecutionHandlerPolicy() {
            return this.rejectedExecutionHandlerPolicy;
        }

        public Duration getExecutorShutdownTimeout() {
            return this.executorShutdownTimeout;
        }

        public void setCorePoolSize(Integer corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaximumPoolSize(Integer maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public void setKeepAliveTime(Integer keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public void setBlockingQueueCapacity(Integer blockingQueueCapacity) {
            this.blockingQueueCapacity = blockingQueueCapacity;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public void setRejectedExecutionHandlerPolicy(RejectedExecutionHandlerPolicy rejectedExecutionHandlerPolicy) {
            this.rejectedExecutionHandlerPolicy = rejectedExecutionHandlerPolicy;
        }

        public void setExecutorShutdownTimeout(Duration executorShutdownTimeout) {
            this.executorShutdownTimeout = executorShutdownTimeout;
        }
    }

    public static class JobTaskScheduledExecutorProperties {
        private Integer corePoolSize = 0;
        private Integer keepAliveTime = 10;
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        private String poolName = "accessTokenJob";
        private RejectedExecutionHandlerPolicy rejectedExecutionHandlerPolicy = RejectedExecutionHandlerPolicy.ABORT;
        private Duration executorShutdownTimeout = Duration.ofSeconds(10L);

        public Integer getCorePoolSize() {
            return this.corePoolSize;
        }

        public Integer getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public RejectedExecutionHandlerPolicy getRejectedExecutionHandlerPolicy() {
            return this.rejectedExecutionHandlerPolicy;
        }

        public Duration getExecutorShutdownTimeout() {
            return this.executorShutdownTimeout;
        }

        public void setCorePoolSize(Integer corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setKeepAliveTime(Integer keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public void setRejectedExecutionHandlerPolicy(RejectedExecutionHandlerPolicy rejectedExecutionHandlerPolicy) {
            this.rejectedExecutionHandlerPolicy = rejectedExecutionHandlerPolicy;
        }

        public void setExecutorShutdownTimeout(Duration executorShutdownTimeout) {
            this.executorShutdownTimeout = executorShutdownTimeout;
        }
    }
}

