/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.aspect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.lang.NonNull;
import top.dcenter.ums.security.core.api.permission.service.RolePermissionsService;
import top.dcenter.ums.security.core.permission.enums.ResourcesType;
import top.dcenter.ums.security.core.permission.event.UpdateRolesAuthoritiesEvent;

@Aspect
public class RolePermissionsServiceAspect
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RolePermissionsServiceAspect.class);
    private ApplicationContext applicationContext;

    @AfterReturning(pointcut="execution(boolean *..updateResourcesOfRole(..)) && args(roleId, resourceIds)", returning="result", argNames="jp, result, roleId, resourceIds")
    public void handlerUpdateRolesAuthoritiesMethod(JoinPoint jp, boolean result, Long roleId, Long ... resourceIds) {
        if (jp.getTarget() instanceof RolePermissionsService && result) {
            this.applicationContext.publishEvent((ApplicationEvent)new UpdateRolesAuthoritiesEvent(true, ResourcesType.ROLE));
        }
    }

    @AfterReturning(pointcut="execution(boolean *..updateAuthoritiesOfAllTenant(..)) && args(tenantAuthority, roleId, resourceIds)", returning="result", argNames="jp, result, tenantAuthority, roleId, resourceIds")
    public void handlerUpdateTenantsAuthoritiesMethod(JoinPoint jp, boolean result, String tenantAuthority, Long roleId, Long ... resourceIds) {
        if (jp.getTarget() instanceof RolePermissionsService && result) {
            this.applicationContext.publishEvent((ApplicationEvent)new UpdateRolesAuthoritiesEvent(true, ResourcesType.TENANT));
        }
    }

    @AfterReturning(pointcut="execution(boolean *..updateAuthoritiesOfAllScopes(..)) && args(scopeAuthority, roleId, resourceIds)", returning="result", argNames="jp, result, scopeAuthority, roleId, resourceIds")
    public void handlerUpdateScopesAuthoritiesMethod(JoinPoint jp, boolean result, String scopeAuthority, Long roleId, Long ... resourceIds) {
        if (jp.getTarget() instanceof RolePermissionsService && result) {
            this.applicationContext.publishEvent((ApplicationEvent)new UpdateRolesAuthoritiesEvent(true, ResourcesType.SCOPE));
        }
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

