/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.config;

import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.EnableAsync;
import top.dcenter.ums.security.core.api.permission.service.UpdateAndCacheAuthoritiesService;
import top.dcenter.ums.security.core.api.permission.service.UriAuthorizeService;
import top.dcenter.ums.security.core.auth.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.permission.aspect.RolePermissionsServiceAspect;
import top.dcenter.ums.security.core.permission.evaluator.UriAuthoritiesPermissionEvaluator;
import top.dcenter.ums.security.core.permission.listener.UpdateRolesAuthoritiesListener;
import top.dcenter.ums.security.core.permission.service.DefaultUriAuthorizeService;

@Configuration
@EnableAsync
@EnableAspectJAutoProxy
@Order(value=99)
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
public class PermissionAutoConfiguration {
    @Bean
    @ConditionalOnBean(type={"top.dcenter.ums.security.core.api.permission.service.UpdateAndCacheAuthoritiesService"})
    public UpdateRolesAuthoritiesListener updateRolesAuthoritiesListener(UpdateAndCacheAuthoritiesService updateAndCacheAuthoritiesService) {
        return new UpdateRolesAuthoritiesListener(updateAndCacheAuthoritiesService);
    }

    @Bean
    @ConditionalOnBean(type={"top.dcenter.ums.security.core.api.permission.service.UpdateAndCacheAuthoritiesService"})
    public RolePermissionsServiceAspect rolePermissionsServiceAspect() {
        return new RolePermissionsServiceAspect();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.permission.service.UriAuthorizeService"})
    public UriAuthorizeService uriAuthorizeService() {
        return new DefaultUriAuthorizeService();
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.security.access.PermissionEvaluator"})
    public UriAuthoritiesPermissionEvaluator uriAuthoritiesPermissionEvaluator(UriAuthorizeService uriAuthorizeService) {
        return new UriAuthoritiesPermissionEvaluator(uriAuthorizeService);
    }
}

