/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.core.auth.filter.AjaxOrFormRequestFilter;
import top.dcenter.ums.security.core.util.ConvertUtil;
import top.dcenter.ums.security.core.util.MvcUtil;

public class RequestUtil {
    public static final String VALIDATE_JSON_PREFIX = "{";
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static <T> T extractRequest2Object(HttpServletRequest request, ObjectMapper objectMapper, Class<T> clz) {
        try {
            byte[] bodies;
            if (request instanceof AjaxOrFormRequestFilter.AjaxOrFormRequest) {
                AjaxOrFormRequestFilter.AjaxOrFormRequest ajaxOrFormRequest = (AjaxOrFormRequestFilter.AjaxOrFormRequest)request;
                bodies = Optional.ofNullable(ajaxOrFormRequest.getBody()).orElse("".getBytes(StandardCharsets.UTF_8));
            } else {
                bodies = RequestUtil.readAllBytes((InputStream)request.getInputStream());
            }
            String requestBody = new String(bodies, StandardCharsets.UTF_8).trim();
            if (!StringUtils.hasText((String)requestBody)) {
                return null;
            }
            return RequestUtil.requestBody2Object(objectMapper, clz, requestBody);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T requestBody2Object(ObjectMapper objectMapper, Class<T> clz, String requestBody) throws JsonProcessingException {
        if (!StringUtils.hasText((String)requestBody)) {
            return null;
        }
        if (requestBody.startsWith(VALIDATE_JSON_PREFIX)) {
            return (T)objectMapper.readValue(requestBody, clz);
        }
        Map<String, Object> map = ConvertUtil.string2JsonMap(requestBody, "&", "=");
        return (T)objectMapper.readValue(map.toString(), clz);
    }

    public static String getRequestUri(String url) {
        String servletContextPath;
        int endIndex;
        if (UrlUtils.isAbsoluteUrl((String)url)) {
            url = url.replaceFirst("\\A[a-z0-9.+-]+://", "");
            url = url.substring(url.indexOf("/"));
        }
        if ((endIndex = url.indexOf("?")) > 0) {
            url = url.substring(0, endIndex);
        }
        if ((endIndex = url.indexOf("#")) > 0) {
            url = url.substring(0, endIndex);
        }
        if (url.startsWith(servletContextPath = MvcUtil.getServletContextPath())) {
            url = url.substring(servletContextPath.length());
        }
        return url;
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        return RequestUtil.readNBytes(Integer.MAX_VALUE, inputStream);
    }

    private static byte[] readNBytes(int len, InputStream inputStream) throws IOException {
        int n;
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = len;
        do {
            byte[] buf = new byte[Math.min(remaining, 8192)];
            int nread = 0;
            while ((n = inputStream.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }
}

