/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.job;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import top.dcenter.ums.security.core.api.validate.code.job.RefreshValidateCodeJob;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.util.MvcUtil;

public class DefaultRefreshValidateCodeJobImpl
implements RefreshValidateCodeJob,
InitializingBean {
    private final ValidateCodeProperties validateCodeProperties;
    private final ScheduledExecutorService jobTaskScheduledExecutor;
    @Autowired
    private Map<String, RefreshValidateCodeJob> refreshValidateCodeJobMap;

    public DefaultRefreshValidateCodeJobImpl(ValidateCodeProperties validateCodeProperties, @Qualifier(value="jobTaskScheduledExecutor") ScheduledExecutorService jobTaskScheduledExecutor) {
        this.validateCodeProperties = validateCodeProperties;
        this.jobTaskScheduledExecutor = jobTaskScheduledExecutor;
    }

    @Override
    @Scheduled(cron="0 * 4 * * ?")
    public void refreshValidateCodeJob() {
        this.jobTaskScheduledExecutor.schedule(() -> {
            if (this.refreshValidateCodeJobMap == null) {
                return;
            }
            Collection<RefreshValidateCodeJob> validateCodeJobs = this.refreshValidateCodeJobMap.values();
            validateCodeJobs.forEach(RefreshValidateCodeJob::refreshValidateCodeJob);
        }, 10L, TimeUnit.MILLISECONDS);
    }

    public void afterPropertiesSet() throws Exception {
        String methodName = "refreshValidateCodeJob";
        if (this.validateCodeProperties.getEnableRefreshValidateCodeJob().booleanValue()) {
            MvcUtil.setScheduledCron(methodName, this.validateCodeProperties.getRefreshValidateCodeJobCron(), this.getClass(), new Class[0]);
        }
    }
}

