/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.config;

import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchyImpl;
import org.springframework.security.access.vote.RoleHierarchyVoter;
import top.dcenter.ums.security.core.auth.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class})
public class RoleHierarchyAutoConfiguration {
    private final ClientProperties clientProperties;

    public RoleHierarchyAutoConfiguration(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Bean
    public RoleHierarchy roleHierarchy() {
        RoleHierarchyImpl roleHierarchy = new RoleHierarchyImpl();
        List<String> roleHierarchyList = this.clientProperties.getRoleHierarchy();
        String roleHierarchyStringRepresentation = String.join((CharSequence)"\n", roleHierarchyList);
        roleHierarchy.setHierarchy(roleHierarchyStringRepresentation);
        return roleHierarchy;
    }

    @Bean
    public RoleHierarchyVoter roleHierarchyVoter(RoleHierarchy roleHierarchy) {
        return new RoleHierarchyVoter(roleHierarchy);
    }
}

