/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.permission.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.permission.service.AbstractUriAuthorizeService;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.vo.ResponseResult;

public class DefaultUriAuthorizeService
extends AbstractUriAuthorizeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUriAuthorizeService.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    @NonNull
    public Map<String, Map<String, Set<String>>> getRolesAuthorities() {
        log.error("\u4f7f\u7528\u57fa\u4e8e \u89d2\u8272 \u7684\u6743\u9650\u670d\u52a1\u5fc5\u987b\u5b9e\u73b0\u6b64\u63a5\u53e3.");
        throw new RuntimeException("\u672a\u5b9e\u73b0\u83b7\u53d6\u6240\u6709\u89d2\u8272\u7684 uri(\u8d44\u6e90) \u7684\u6743\u9650");
    }

    @Override
    @NonNull
    public Map<String, Map<String, Set<String>>> getRolesAuthoritiesOfTenant(String tenantAuthority) {
        log.error("\u4f7f\u7528 \u591a\u79df\u6237 \u6743\u9650\u670d\u52a1\u5fc5\u987b\u5b9e\u73b0\u6b64\u63a5\u53e3.");
        throw new RuntimeException("\u672a\u5b9e\u73b0\u83b7\u53d6\u591a\u79df\u6237\u7684\u6240\u6709\u89d2\u8272\u7684 uri(\u8d44\u6e90) \u7684\u6743\u9650");
    }

    @Override
    @NonNull
    public Map<String, Map<String, Set<String>>> getRolesAuthoritiesOfScope(Set<String> scopeSet) {
        log.error("\u4f7f\u7528 SCOPE \u6743\u9650\u670d\u52a1\u5fc5\u987b\u5b9e\u73b0\u6b64\u63a5\u53e3.");
        throw new RuntimeException("\u672a\u5b9e\u73b0\u83b7\u53d6 SCOPE \u7684\u6240\u6709\u89d2\u8272\u7684 uri(\u8d44\u6e90) \u7684\u6743\u9650");
    }

    @Override
    public void handlerError(int status, HttpServletResponse response) {
        try {
            AuthenticationUtil.responseWithJson(response, status, this.objectMapper.writeValueAsString((Object)ResponseResult.fail(ErrorCodeEnum.PERMISSION_DENY)));
        }
        catch (IOException e) {
            log.error(String.format("\u6743\u9650\u63a7\u5236\u9519\u8bef\u54cd\u5e94\u5f02\u5e38: status=%s, error=%s", status, e.getMessage()), (Throwable)e);
        }
    }
}

