/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.handler;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.auth.filter.AjaxOrFormRequestFilter;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.IpUtil;

public class ClientAuthenticationFailureHandler
extends BaseAuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(ClientAuthenticationFailureHandler.class);
    protected final ClientProperties clientProperties;

    public ClientAuthenticationFailureHandler(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
        this.setDefaultFailureUrl(clientProperties.getFailureUrl());
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String reqData;
        AbstractResponseJsonAuthenticationException e = AuthenticationUtil.getAbstractResponseJsonAuthenticationException(exception);
        if (request instanceof AjaxOrFormRequestFilter.AjaxOrFormRequest) {
            AjaxOrFormRequestFilter.AjaxOrFormRequest ajaxOrFormRequest = (AjaxOrFormRequestFilter.AjaxOrFormRequest)request;
            Map<String, Object> formMap = ajaxOrFormRequest.getFormMap();
            if (formMap != null) {
                formMap.computeIfPresent(this.clientProperties.passwordParameter, (k, v) -> {
                    v = "PROTECTED";
                    return "PROTECTED";
                });
                reqData = formMap.toString();
            } else {
                reqData = request.getQueryString();
            }
        } else {
            Map parameterMap = request.getParameterMap();
            parameterMap.computeIfPresent(this.clientProperties.passwordParameter, (k, v) -> {
                v = new String[]{"PROTECTED"};
                return v;
            });
            reqData = parameterMap.toString();
        }
        log.info("\u767b\u5f55\u5931\u8d25: user={}, ip={}, ua={}, sid={}, reqData={}", new Object[]{e == null ? null : e.getUid(), IpUtil.getRealIp(request), request.getHeader("User-Agent"), request.getSession(true).getId(), reqData});
        String acceptHeader = request.getHeader("accept");
        if (AuthenticationUtil.authenticationFailureProcessing(response, exception, e, acceptHeader, this.clientProperties)) {
            return;
        }
        super.onAuthenticationFailure(request, response, exception);
    }
}

