/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.validate.codes.slider;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class SliderCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(SliderCodeUtil.class);
    public static final int WIDTH_RATE = 3;
    public static final int HEIGHT_RATE = 2;

    public static File getRandomImageFile(String[] imageAbsPaths, ThreadLocalRandom random) {
        String imageAbsPath = imageAbsPaths[random.nextInt(imageAbsPaths.length)];
        return Paths.get(imageAbsPath, new String[0]).toFile();
    }

    public static byte[] getImageByteBASE64(BufferedImage image) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", out);
        byte[] bytes = out.toByteArray();
        return Base64Utils.encode((byte[])bytes);
    }

    public static Map<String, Object> cutImageByTemplate(BufferedImage imageTemplate, BufferedImage imageTarget, int grayscale) {
        HashMap<String, Object> sliderCodeInfoMap = new HashMap<String, Object>(4);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int width = imageTemplate.getWidth();
        int height = imageTemplate.getHeight();
        int srcWidth = imageTarget.getWidth();
        int srcHeight = imageTarget.getHeight();
        if (srcWidth / width < 3 && srcHeight / height < 2) {
            String msg = String.format("\u6a21\u677f\u56fe\u7247\u5bbd\u9ad8\u4e0d\u7b26\u5408\u6e90\u56fe\u7247\u7684\u5bbd\u9ad8: \u6e90\u56fe\u7247\u5bbd\u5fc5\u987b\u5927\u4e8e\u6a21\u677f\u56fe\u7247\u5bbd\u7684 %d \u500d, \u6e90\u56fe\u7247\u9ad8\u5fc5\u987b\u5927\u4e8e\u6a21\u677f\u56fe\u7247\u9ad8\u7684 %d \u500d", 3, 2);
            throw new RuntimeException(msg);
        }
        int offsetX = width / 10;
        int locationX = offsetX + random.nextInt(srcWidth - width - offsetX);
        int offsetY = height / 10;
        int locationY = offsetY + random.nextInt(srcHeight - height - offsetY);
        Graphics2D graphics = imageTemplate.createGraphics();
        graphics.setBackground(Color.white);
        SliderCodeUtil.cutImageByTemplate(imageTarget, imageTemplate, grayscale, locationX, locationY);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setStroke(new BasicStroke(5.0f, 0, 2));
        graphics.drawImage((Image)imageTemplate, 0, 0, null);
        graphics.dispose();
        sliderCodeInfoMap.put("markImage", imageTemplate);
        sliderCodeInfoMap.put("srcImage", imageTarget);
        sliderCodeInfoMap.put("locationX", locationX);
        sliderCodeInfoMap.put("locationY", locationY);
        return sliderCodeInfoMap;
    }

    private static void cutImageByTemplate(BufferedImage oriImage, BufferedImage templateImage, int grayscale, int locationX, int locationY) {
        int[][] oriImageData = SliderCodeUtil.getImageData(oriImage);
        int[][] templateImageData = SliderCodeUtil.getImageData(templateImage);
        int width = oriImageData.length;
        int height = oriImageData[0].length;
        int cutWidth = templateImageData.length;
        int cutHeight = templateImageData[0].length;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                boolean isMarkTarget;
                boolean bl = isMarkTarget = i >= locationX && j >= locationY && i < locationX + cutWidth && j < locationY + cutHeight;
                if (!isMarkTarget) continue;
                int rgb = oriImage.getRGB(i, j);
                int templateRgb = templateImage.getRGB(i - locationX, j - locationY);
                if (templateRgb != 0xFFFFFF && templateRgb != -1 && templateRgb <= 0) {
                    templateImage.setRGB(i - locationX, j - locationY, rgb);
                    int r = 0xFF & rgb;
                    int g = 0xFF & rgb >> 8;
                    int b = 0xFF & rgb >> 16;
                    int gray = (r + g + b) / grayscale;
                    rgb = 0xFF000000 | gray << 16 | gray << 8 | gray;
                    oriImage.setRGB(i, j, rgb);
                    continue;
                }
                templateImage.setRGB(i - locationX, j - locationY, rgb &= 0xFFFFFF);
            }
        }
    }

    private static int[][] getImageData(BufferedImage bufferedImage) {
        int[][] data = new int[bufferedImage.getWidth()][bufferedImage.getHeight()];
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                data[i][j] = bufferedImage.getRGB(i, j);
            }
        }
        return data;
    }
}

