/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.config;

import java.util.concurrent.ExecutorService;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.oauth.state.service.Auth2StateCoder;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.oauth.config.Auth2AutoConfiguration;
import top.dcenter.ums.security.core.oauth.filter.login.Auth2LoginAuthenticationFilter;
import top.dcenter.ums.security.core.oauth.filter.redirect.Auth2DefaultRequestRedirectFilter;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.provider.Auth2LoginAuthenticationProvider;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionRepository;
import top.dcenter.ums.security.core.oauth.service.Auth2UserService;
import top.dcenter.ums.security.core.oauth.signup.ConnectionService;
import top.dcenter.ums.security.core.util.AuthenticationUtil;

@Configuration
@ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={Auth2AutoConfiguration.class})
public class Auth2AutoConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final Auth2Properties auth2Properties;
    private final UmsUserDetailsService umsUserDetailsService;
    private final Auth2UserService auth2UserService;
    private final UsersConnectionRepository usersConnectionRepository;
    private final ConnectionService connectionSignUp;
    private final ExecutorService updateConnectionTaskExecutor;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler;
    @Autowired(required=false)
    private Auth2StateCoder auth2StateCoder;
    @Autowired
    private UmsUserDetailsService userDetailsService;
    @Autowired(required=false)
    private PersistentTokenRepository persistentTokenRepository;
    @Autowired
    private ClientProperties clientProperties;

    public Auth2AutoConfigurer(Auth2Properties auth2Properties, UmsUserDetailsService umsUserDetailsService, Auth2UserService auth2UserService, UsersConnectionRepository usersConnectionRepository, ConnectionService connectionSignUp, @Qualifier(value="updateConnectionTaskExecutor") ExecutorService updateConnectionTaskExecutor, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler) {
        this.auth2Properties = auth2Properties;
        this.umsUserDetailsService = umsUserDetailsService;
        this.auth2UserService = auth2UserService;
        this.usersConnectionRepository = usersConnectionRepository;
        this.connectionSignUp = connectionSignUp;
        this.updateConnectionTaskExecutor = updateConnectionTaskExecutor;
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.baseAuthenticationSuccessHandler = baseAuthenticationSuccessHandler;
    }

    public void configure(HttpSecurity http) {
        String authorizationRequestBaseUri = this.auth2Properties.getAuthLoginUrlPrefix();
        Auth2DefaultRequestRedirectFilter auth2DefaultRequestRedirectFilter = new Auth2DefaultRequestRedirectFilter(authorizationRequestBaseUri, this.auth2StateCoder, (SimpleUrlAuthenticationFailureHandler)this.baseAuthenticationFailureHandler);
        http.addFilterAfter((Filter)this.postProcess((Object)auth2DefaultRequestRedirectFilter), AbstractPreAuthenticatedProcessingFilter.class);
        String filterProcessesUrl = this.auth2Properties.getRedirectUrlPrefix();
        Auth2LoginAuthenticationFilter auth2LoginAuthenticationFilter = new Auth2LoginAuthenticationFilter(filterProcessesUrl, this.auth2Properties.getSignUpUrl());
        AuthenticationManager sharedObject = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
        auth2LoginAuthenticationFilter.setAuthenticationManager(sharedObject);
        AuthenticationUtil.registerHandlerAndRememberMeServices(auth2LoginAuthenticationFilter, this.baseAuthenticationSuccessHandler, this.baseAuthenticationFailureHandler, this.persistentTokenRepository, this.userDetailsService, this.clientProperties);
        http.addFilterAfter((Filter)this.postProcess((Object)auth2LoginAuthenticationFilter), OAuth2AuthorizationRequestRedirectFilter.class);
        Auth2LoginAuthenticationProvider auth2LoginAuthenticationProvider = new Auth2LoginAuthenticationProvider(this.auth2UserService, this.connectionSignUp, this.umsUserDetailsService, this.usersConnectionRepository, this.updateConnectionTaskExecutor, this.auth2Properties.getAutoSignUp(), this.auth2Properties.getTemporaryUserAuthorities(), this.auth2Properties.getTemporaryUserPassword());
        http.authenticationProvider((AuthenticationProvider)this.postProcess(auth2LoginAuthenticationProvider));
    }
}

