/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.validate.code;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.GenericApplicationContext;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeProcessor;
import top.dcenter.ums.security.core.api.validate.code.enums.ValidateCodeType;
import top.dcenter.ums.security.core.auth.properties.ValidateCodeProperties;

public class ValidateCodeProcessorHolder
implements InitializingBean {
    private Map<String, ValidateCodeProcessor> validateCodeProcessors;
    @Autowired
    private GenericApplicationContext applicationContext;

    public ValidateCodeProcessor findValidateCodeProcessor(ValidateCodeType type) {
        ValidateCodeProcessor validateCodeProcessor;
        if (type == null) {
            return null;
        }
        try {
            validateCodeProcessor = this.validateCodeProcessors.get(type.name().toLowerCase());
        }
        catch (Exception e) {
            validateCodeProcessor = null;
        }
        return validateCodeProcessor;
    }

    public ValidateCodeProcessor findValidateCodeProcessor(String type) {
        if (type == null) {
            return null;
        }
        return this.validateCodeProcessors.get(type);
    }

    public void afterPropertiesSet() throws NoSuchFieldException, IllegalAccessException {
        Map validateCodeProcessorMap = this.applicationContext.getBeansOfType(ValidateCodeProcessor.class);
        Collection values = validateCodeProcessorMap.values();
        this.validateCodeProcessors = values.stream().collect(Collectors.toMap(validateCodeProcessor -> validateCodeProcessor.getValidateCodeType().name().toLowerCase(), validateCodeProcessor -> validateCodeProcessor));
        ValidateCodeProperties properties = (ValidateCodeProperties)this.applicationContext.getBean(ValidateCodeProperties.class);
        this.setExpireIn(ValidateCodeType.IMAGE, properties.getImage().getExpire());
        this.setExpireIn(ValidateCodeType.SMS, properties.getSms().getExpire());
        this.setExpireIn(ValidateCodeType.SLIDER, properties.getSlider().getExpire());
        this.setExpireIn(ValidateCodeType.TRACK, properties.getTrack().getExpire());
        this.setExpireIn(ValidateCodeType.SELECTION, properties.getSelection().getExpire());
        this.setExpireIn(ValidateCodeType.CUSTOMIZE, properties.getCustomize().getExpire());
    }

    private void setExpireIn(ValidateCodeType validateCodeType, Integer expireIn) throws NoSuchFieldException, IllegalAccessException {
        Field expireInField = ((Object)((Object)validateCodeType)).getClass().getSuperclass().getDeclaredField("expireIn");
        expireInField.setAccessible(true);
        expireInField.set((Object)validateCodeType, expireIn);
    }
}

